/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bns;

import com.baidu.driver4j.bns.BNSException;
import com.baidu.driver4j.bns.BNSHead;
import com.baidu.driver4j.bns.BNSQueryProxy;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.InstanceQuery;
import com.baidu.driver4j.bns.SelectionStrategy;
import com.baidu.driver4j.bns.Service;
import com.baidu.driver4j.bns.SocketUtils;
import com.baidu.driver4j.bns.StringUtils;
import com.baidu.noah.naming.msg.NamingProtos;
import com.baidu.noah.naming.msg.ServiceProtos;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BNSQueryAgentProxy
implements InstanceQuery {
    private static final int QUERY_INSTANCE_STATUS = 0;
    private static final String PORT_NAME_SPLIT = "=";
    private static final String MULTI_PORT_SPLIT = ",";
    private static final String DEFAULT_TOKEN = "00000000";
    private static final String PROC_NET_ROUTE_COMMAND = "/proc/net/route";
    private static final String JPAAS_HOST_NAME = "JPAAS_HOST";
    private static final String LOCAL_IP_STARTS = "192.168";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNSQueryAgentProxy.class.getName());
    private BNSQueryProxy bnsQueryProxy;
    private static final String LOCAL_NAMED_ADDR = "127.0.0.1";
    private static final int LOCAL_NAMED_PORT = 793;
    private static final String REMOTE_NAMED_ADDR = "unamed.noah.baidu.com";
    private static final int REMOTE_NAMED_PORT = 793;
    private static final int DEFAULT_TIMEOUT_MS = 3000;
    private static final short MSG_TYPE_NAMING_REQ = 1;
    private static final short MSG_TYPE_AUTH_REQ = 2;
    private static final short MSG_TYPE_NAMING_RESP = 3;
    private static final short MSG_TYPE_AUTH_RESP = 4;
    private static final short MSG_TYPE_CONF_REQ = 15;
    private static final short MSG_TYPE_CONF_RESP = 16;
    private static final int RET_CODE_SERVICE_NOTEXIST = -1;
    private static final int RET_CODE_BEYOND_THRESHOLD = -16;
    private static final int MIN_TIME_OUT = 500;
    private int connectTimeout = 1000;
    private int readTimeout = 3000;

    private BNSQueryAgentProxy(String bnsService) {
        this.bnsQueryProxy = BNSQueryProxy.proxy((String)bnsService);
    }

    private BNSQueryAgentProxy(BNSQueryProxy proxy) {
        Assert.notNull((Object)proxy, (String)"Property 'proxy' of type BNSQueryProxy is null ");
        this.bnsQueryProxy = proxy;
    }

    public static BNSQueryAgentProxy proxy() {
        return new BNSQueryAgentProxy("http://noah.baidu.com/webfoot/index.php");
    }

    public static BNSQueryAgentProxy proxy(String bnsServiceUrl) {
        return new BNSQueryAgentProxy(bnsServiceUrl);
    }

    public static BNSQueryAgentProxy proxy(BNSQueryProxy proxy) {
        return new BNSQueryAgentProxy(proxy);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.bnsQueryProxy.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.bnsQueryProxy.setReadTimeout(readTimeout);
    }

    public Instance getInstanceByService(String serviceName, SelectionStrategy strategy) throws BNSException {
        return this.getInstanceByService(serviceName, strategy, this.readTimeout);
    }

    public Instance getInstanceByService(String serviceName, SelectionStrategy strategy, int timeout) throws BNSException {
        if (strategy == null) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "SelectionStrategy 'strategy' is null.");
        }
        List<Instance> instances = this.getInstanceByService(serviceName, timeout);
        return this.selectOneByStrategy(instances, strategy);
    }

    protected Instance selectOneByStrategy(List<Instance> instances, SelectionStrategy strategy) {
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        Instance ret = null;
        int decideValue = -1;
        for (Instance instance : instances) {
            int deciding = strategy.deciding(instance);
            if (deciding < 0) {
                deciding = 0;
            } else if (deciding > 100) {
                deciding = 100;
            }
            if (deciding == 100) {
                return instance;
            }
            if (deciding <= decideValue) continue;
            ret = instance;
            decideValue = deciding;
        }
        return ret;
    }

    public List<Instance> getInstanceByService(String serviceName) throws BNSException {
        return this.getInstanceByService(serviceName, this.readTimeout);
    }

    public List<Instance> getInstanceByService(String serviceName, int timeoutMs) throws BNSException {
        NamingProtos.LocalNamingResponse responsePb;
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "serivce name is blank.");
        }
        int timeout = timeoutMs;
        if (timeoutMs < 500) {
            timeout = 500;
        }
        int eachTimeout = timeout / 3;
        long expiredTime = System.currentTimeMillis() + (long)timeoutMs;
        NamingProtos.LocalNamingRequest.Builder builder = NamingProtos.LocalNamingRequest.newBuilder();
        builder.setAll(true).setPid(0).setServiceName(serviceName);
        builder.setClientInfo(NamingProtos.ClientInfo.newBuilder().setType(20));
        NamingProtos.LocalNamingRequest request = builder.build();
        byte[] requestBodyBytes = request.toByteArray();
        byte[] bytesRet = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Try to getInstanceByService by local agent");
            }
            bytesRet = this.doRequest(BNSQueryAgentProxy.getLocalNamedAddress(), 793, requestBodyBytes, (short)1, (short)3, eachTimeout);
        }
        catch (BNSException e) {
            if (System.currentTimeMillis() > expiredTime) {
                throw new BNSException(BNSException.ErrorCode.BNS_INTERACT_TIMEOUT_ERROR, "A error found '" + e.getMessage() + " '  then cause time out of " + timeoutMs + " ms");
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get from local agent, try to getInstanceByService by remote agent");
                }
                bytesRet = this.doRequest(REMOTE_NAMED_ADDR, 793, requestBodyBytes, (short)1, (short)3, eachTimeout);
            }
            catch (BNSException e2) {
                if (System.currentTimeMillis() > expiredTime) {
                    throw new BNSException(BNSException.ErrorCode.BNS_INTERACT_TIMEOUT_ERROR, "A error found '" + e2.getMessage() + " '  then cause time out of " + timeoutMs + " ms");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get from remote agent, try to getInstanceByService by HTTP API");
                }
                List instances = this.bnsQueryProxy.getInstances(serviceName, new int[]{0});
                return instances;
            }
        }
        try {
            responsePb = NamingProtos.LocalNamingResponse.parseFrom(bytesRet);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Parse recv data error:" + e.getMessage());
        }
        this.checkResponseCode(responsePb.getRetcode());
        List<ServiceProtos.InstanceInfo> instanceInfoList = responsePb.getInstanceInfoList();
        ArrayList<Instance> result = new ArrayList<Instance>(instanceInfoList.size());
        for (ServiceProtos.InstanceInfo instanceInfo : instanceInfoList) {
            int status = instanceInfo.getInstanceStatus().getStatus();
            if (status != 0) {
                LOGGER.warn("The status of instance name '" + instanceInfo.getHostName() + "' is " + status + " which" + " will ignored to add to query list.");
                continue;
            }
            Instance instance = this.wrapInstance(instanceInfo);
            instance.setServiceName(serviceName);
            result.add(instance);
        }
        return result;
    }

    public List<Instance> getAuthInstanceByService(String serviceName) throws BNSException {
        return this.getAuthInstanceByService(serviceName, this.readTimeout);
    }

    public List<Instance> getAuthInstanceByService(String serviceName, int timeoutMs) throws BNSException {
        NamingProtos.LocalNamingAuthResponse responsePb;
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "serivce name is blank.");
        }
        int timeout = timeoutMs;
        if (timeoutMs < 500) {
            timeout = 500;
        }
        int eachTimeout = timeout / 2;
        long expiredTime = System.currentTimeMillis() + (long)timeoutMs;
        NamingProtos.LocalNamingAuthRequest request = NamingProtos.LocalNamingAuthRequest.newBuilder().setAll(true).setPid(0).setServiceName(serviceName).build();
        byte[] requestBodyBytes = request.toByteArray();
        byte[] bytesRet = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Try to getInstanceByService by local agent");
            }
            bytesRet = this.doRequest(BNSQueryAgentProxy.getLocalNamedAddress(), 793, requestBodyBytes, (short)2, (short)4, eachTimeout);
        }
        catch (BNSException e) {
            if (System.currentTimeMillis() > expiredTime) {
                throw new BNSException(BNSException.ErrorCode.BNS_INTERACT_TIMEOUT_ERROR, "A error found '" + e.getMessage() + " '  then cause time out of " + timeoutMs + " ms");
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get from local agent, try to getInstanceByService by remote agent");
                }
                bytesRet = this.doRequest(REMOTE_NAMED_ADDR, 793, requestBodyBytes, (short)2, (short)4, eachTimeout);
            }
            catch (BNSException e2) {
                throw new BNSException(BNSException.ErrorCode.BNS_INTERACT_TIMEOUT_ERROR, "A error found '" + e2.getMessage() + " '  then cause time out of " + timeoutMs + " ms");
            }
        }
        try {
            responsePb = NamingProtos.LocalNamingAuthResponse.parseFrom(bytesRet);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Parse recv data error:" + e.getMessage());
        }
        this.checkResponseCode(responsePb.getRetcode());
        List<ServiceProtos.ServiceHostList> serviceHostList = responsePb.getTrustedServicesList();
        ArrayList<Instance> result = new ArrayList<Instance>(serviceHostList.size());
        for (ServiceProtos.ServiceHostList instanceInfo : serviceHostList) {
            for (ServiceProtos.HostIpPair host : instanceInfo.getHostIpPairList()) {
                Instance instance = new Instance();
                instance.setServiceName(instanceInfo.getServiceName());
                instance.setHostName(host.getHostName());
                instance.setIp(host.getHostIp());
                result.add(instance);
            }
        }
        return result;
    }

    public Service getService(String serviceName) {
        return this.getService(serviceName, this.readTimeout);
    }

    public Service getService(String serviceName, int timeoutMs) {
        NamingProtos.LocalServiceConfResponse responsePb;
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "serivce name is blank.");
        }
        int timeout = timeoutMs;
        if (timeoutMs < 500) {
            timeout = 500;
        }
        int eachTimeout = timeout / 3;
        long expiredTime = System.currentTimeMillis() + (long)timeoutMs;
        NamingProtos.LocalServiceConfRequest request = NamingProtos.LocalServiceConfRequest.newBuilder().setPid(-1).setServiceName(serviceName).setClientInfo(NamingProtos.ClientInfo.newBuilder().setType(20)).build();
        byte[] requestBodyBytes = request.toByteArray();
        byte[] bytesRet = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Try to getInstanceByService by local agent");
            }
            bytesRet = this.doRequest(BNSQueryAgentProxy.getLocalNamedAddress(), 793, requestBodyBytes, (short)15, (short)16, timeoutMs);
        }
        catch (BNSException e) {
            if (System.currentTimeMillis() > expiredTime) {
                throw new BNSException(BNSException.ErrorCode.BNS_INTERACT_TIMEOUT_ERROR, "A error found '" + e.getMessage() + " '  then cause time out of " + timeoutMs + " ms");
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get from local agent, try to getInstanceByService by remote agent");
                }
                bytesRet = this.doRequest(REMOTE_NAMED_ADDR, 793, requestBodyBytes, (short)15, (short)16, eachTimeout);
            }
            catch (BNSException e2) {
                if (System.currentTimeMillis() > expiredTime) {
                    throw new BNSException(BNSException.ErrorCode.BNS_INTERACT_TIMEOUT_ERROR, "A error found '" + e2.getMessage() + " '  then cause time out of " + timeoutMs + " ms");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get from remote agent, try to getInstanceByService by HTTP API");
                }
                Service service = this.bnsQueryProxy.getService(serviceName);
                return service;
            }
        }
        try {
            responsePb = NamingProtos.LocalServiceConfResponse.parseFrom(bytesRet);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Parse recv data error:" + e.getMessage());
        }
        this.checkResponseCode(responsePb.getRetcode());
        ServiceProtos.ServiceInfo serviceInfo = responsePb.getServiceInfo();
        return this.wrapService(serviceInfo);
    }

    private Service wrapService(ServiceProtos.ServiceInfo serviceInfo) {
        Service service = new Service();
        service.setServiceName(serviceInfo.getServiceName());
        service.setServiceConf(serviceInfo.getServiceConf());
        service.setFlowCtlConf(serviceInfo.getFlowctlconf());
        service.setGroupNames(serviceInfo.getGroupNames());
        service.setQosinfo(serviceInfo.getQosInfo());
        service.setQosopen(serviceInfo.getQosOpen());
        service.setSuType(serviceInfo.getSuType());
        service.setGianoSUser(serviceInfo.getGianoInfo());
        return service;
    }

    private void checkResponseCode(int responseCode) {
        if (responseCode != 0) {
            BNSException.ErrorCode errorCode;
            String msg = "";
            if (responseCode == -1) {
                errorCode = BNSException.ErrorCode.BNS_SERVICE_NOTEXIST;
            } else if (responseCode == -16) {
                errorCode = BNSException.ErrorCode.BNS_SERVICE_BEYOND_THRESHOLD;
            } else {
                errorCode = BNSException.ErrorCode.BNS_RET_UNKNOWN;
                msg = "Unkow retCode from naming-agent:" + errorCode;
            }
            throw new BNSException(errorCode, msg);
        }
    }

    private Instance wrapInstance(ServiceProtos.InstanceInfo instanceInfo) {
        Instance instance = new Instance();
        instance.setIp(instanceInfo.getHostIp());
        instance.setOffset(instanceInfo.getOffset());
        instance.setPortNumber(instanceInfo.getInstanceStatus().getPort());
        instance.setHostName(instanceInfo.getHostName());
        instance.setExtra(instanceInfo.getInstanceStatus().getExtra());
        instance.setTag(instanceInfo.getInstanceStatus().getTags());
        instance.setServiceName(instanceInfo.getServiceName());
        instance.setStatus(instanceInfo.getInstanceStatus().getStatus());
        String multiPort = instanceInfo.getInstanceStatus().getMultiPort();
        if (!StringUtils.isEmpty((String)multiPort)) {
            String[] multiPorts;
            for (String mp : multiPorts = multiPort.split(MULTI_PORT_SPLIT)) {
                String[] ports = mp.split(PORT_NAME_SPLIT);
                if (ports.length != 2 || StringUtils.isEmpty((String)ports[0])) continue;
                instance.addPort(ports[0], ports[1]);
            }
        }
        instance.setLoad(instanceInfo.getInstanceLoad().getLoad());
        return instance;
    }

    protected byte[] doRequest(String host, int port, byte[] requestBodyBytes, short requestMsgType, short expectResponseType, int timeoutMs) throws BNSException {
        Socket socket = null;
        try {
            int timeout = timeoutMs > 0 ? timeoutMs : this.readTimeout;
            socket = SocketUtils.createSocket((String)host, (int)port, (int)this.connectTimeout, (int)timeout);
            socket.setReuseAddress(true);
            SocketUtils.writeSocket((Socket)socket, (byte[])this.getBNSMsgBytes(requestBodyBytes, requestMsgType));
            InputStream is = socket.getInputStream();
            byte[] byArray = this.readBNSMsg(is, expectResponseType);
            return byArray;
        }
        catch (Exception e) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, e.getMessage());
        }
        finally {
            try {
                if (SocketUtils.isSocketConnected(socket)) {
                    socket.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected byte[] getBNSMsgBytes(byte[] requestBodyBytes, short requestMsgType) throws IOException {
        BNSHead reqHead = new BNSHead();
        reqHead.id = requestMsgType;
        reqHead.version = 0;
        reqHead.log_id = new Random().nextInt();
        reqHead.body_len = requestBodyBytes.length;
        byte[] reqHeadByte = reqHead.toBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(requestBodyBytes.length + reqHeadByte.length);
        byteBuffer.put(reqHeadByte);
        byteBuffer.put(requestBodyBytes);
        byte[] ret = byteBuffer.array();
        byteBuffer.clear();
        return ret;
    }

    protected byte[] readBNSMsg(InputStream is, short expectResponseType) throws IOException {
        int ret;
        byte[] respHeadByte = new byte[20];
        int readCount = is.read(respHeadByte, 0, 20);
        if (readCount != 20) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Bad BNSHead, not enough head len, got" + readCount);
        }
        BNSHead respHead = BNSHead.fromBytes((byte[])respHeadByte);
        if (respHead == null || respHead.magic_num != -76508268 || respHead.body_len < 0 || respHead.body_len > 0x1400000) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Bad BNSHead");
        }
        if (respHead.id != expectResponseType) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Not expected msg type, expect " + expectResponseType + ", but got" + respHead.id);
        }
        byte[] respBodyByte = new byte[respHead.body_len];
        for (readCount = 0; readCount < respHead.body_len; readCount += ret) {
            ret = is.read(respBodyByte, readCount, respHead.body_len - readCount);
            if (ret >= 0) continue;
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Shorter body than expected, expect " + respHead.body_len + "B, but got " + readCount + "B");
        }
        return respBodyByte;
    }

    public static String getLocalNamedAddress() {
        String localNamedAddress = LOCAL_NAMED_ADDR;
        String defaultGateway = BNSQueryAgentProxy.getDefaultGateway();
        String jpaasv2Host = null;
        try {
            jpaasv2Host = System.getenv(JPAAS_HOST_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jpaasv2Host != null && jpaasv2Host.length() > 0) {
            localNamedAddress = jpaasv2Host;
        } else if (defaultGateway != null && defaultGateway.startsWith(LOCAL_IP_STARTS)) {
            localNamedAddress = defaultGateway;
        }
        return localNamedAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultGateway() {
        String defaultGateway = null;
        FileReader file = null;
        BufferedReader reader = null;
        try {
            file = new FileReader(PROC_NET_ROUTE_COMMAND);
            reader = new BufferedReader(file);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split("\\s+");
                if (tokens.length <= 3) continue;
                if (!tokens[1].equals(DEFAULT_TOKEN)) continue;
                String gatewayHex = tokens[2];
                if (gatewayHex.length() == 8) {
                    String string = defaultGateway = SocketUtils.hexStringIp2DottedIp((String)gatewayHex);
                    return string;
                }
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), e.getCause());
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), e.getCause());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), e.getCause());
                }
            }
        }
        return defaultGateway;
    }

    public List<Instance> queryInstances(String serviceName) throws BNSException {
        return this.getInstanceByService(serviceName);
    }

    public BNSQueryProxy getBnsQueryProxy() {
        return this.bnsQueryProxy;
    }
}

