/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bns.spring;

import com.baidu.driver4j.bns.BNSQueryAgentProxy;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.spring.BNSCallbackProxyBean;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.CollectionUtils;

public class BNSPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNSCallbackProxyBean.class.getName());
    private Set<String> bnsNamingSerivce;
    private String multiSplit = ";";
    private String hostAndPortJoiner = ":";
    private BNSQueryAgentProxy bnsProxy = BNSQueryAgentProxy.proxy();

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        for (String serviceName : this.bnsNamingSerivce) {
            List<Instance> instances = this.bnsProxy.getInstanceByService(serviceName);
            if (CollectionUtils.isEmpty(instances)) continue;
            String instanceInfo = "";
            Iterator<Instance> iter = instances.iterator();
            while (iter.hasNext()) {
                Instance instance = iter.next();
                instanceInfo = instanceInfo + instance.getHostName() + this.hostAndPortJoiner + instance.getPort();
                if (!iter.hasNext()) continue;
                instanceInfo = instanceInfo + this.multiSplit;
            }
            props.put(serviceName, instanceInfo);
            LOGGER.info("Add service name '" + serviceName + "' from bns to placeholder.");
        }
        super.processProperties(beanFactoryToProcess, props);
    }

    public void setBnsNamingSerivce(Set<String> bnsNamingSerivce) {
        this.bnsNamingSerivce = bnsNamingSerivce;
    }

    public void setMultiSplit(String multiSplit) {
        this.multiSplit = multiSplit;
    }

    public void setHostAndPortJoiner(String hostAndPortJoiner) {
        this.hostAndPortJoiner = hostAndPortJoiner;
    }

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.bnsNamingSerivce)) {
            throw new IllegalArgumentException("Property 'bnsNamingSerivce' is empty");
        }
    }
}

