/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.dubbo;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.alibaba.com.caucho.hessian.io.Hessian2Output;
import com.baidu.brpc.protocol.dubbo.DubboConstants;
import com.baidu.brpc.protocol.dubbo.DubboHeader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DubboPacket {
    private DubboHeader header;
    private ByteBuf bodyBuf;

    public static byte[] encodeHeartbeatBody() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Hessian2Output hessian2Output = new Hessian2Output((OutputStream)outputStream);
        hessian2Output.writeString(DubboConstants.HEARTBEAT_EVENT);
        hessian2Output.flushBuffer();
        byte[] bodyBytes = outputStream.toByteArray();
        return bodyBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeEventBody(ByteBuf bodyBuf) throws IOException {
        ByteBufInputStream inputStream = null;
        try {
            Object bodyObject;
            inputStream = new ByteBufInputStream(bodyBuf, true);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)inputStream);
            Object object = bodyObject = hessian2Input.readObject();
            return object;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void setHeader(DubboHeader header) {
        this.header = header;
    }

    public void setBodyBuf(ByteBuf bodyBuf) {
        this.bodyBuf = bodyBuf;
    }

    public DubboHeader getHeader() {
        return this.header;
    }

    public ByteBuf getBodyBuf() {
        return this.bodyBuf;
    }
}

