/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.BrpcPooledChannel;
import com.baidu.brpc.client.channel.BrpcShortChannel;
import com.baidu.brpc.client.channel.BrpcSingleChannel;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.client.channel.ServiceInstance;

public class BrpcChannelFactory {
    public static BrpcChannel createChannel(ServiceInstance serviceInstance, CommunicationOptions communicationOptions) {
        ChannelType channelType = communicationOptions.getChannelType();
        if (channelType == ChannelType.POOLED_CONNECTION) {
            return new BrpcPooledChannel(serviceInstance, communicationOptions);
        }
        if (channelType == ChannelType.SINGLE_CONNECTION) {
            return new BrpcSingleChannel(serviceInstance, communicationOptions);
        }
        if (channelType == ChannelType.SHORT_CONNECTION) {
            return new BrpcShortChannel(serviceInstance, communicationOptions);
        }
        throw new IllegalArgumentException("channel type is not valid:" + channelType.getName());
    }
}

