/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.channel.AbstractBrpcChannel;
import com.baidu.brpc.client.channel.ChannelPooledObjectFactory;
import com.baidu.brpc.client.channel.ServiceInstance;
import io.netty.channel.Channel;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcPooledChannel
extends AbstractBrpcChannel {
    private static final Logger log = LoggerFactory.getLogger(BrpcPooledChannel.class);
    private GenericObjectPool<Channel> channelFuturePool;
    private volatile long failedNum;
    private int readTimeOut;
    private int latencyWindowSize;
    private Queue<Integer> latencyWindow;

    public BrpcPooledChannel(ServiceInstance serviceInstance, CommunicationOptions communicationOptions) {
        super(serviceInstance, communicationOptions);
        this.readTimeOut = communicationOptions.getReadTimeoutMillis();
        this.latencyWindowSize = communicationOptions.getLatencyWindowSizeOfFairLoadBalance();
        this.latencyWindow = new ConcurrentLinkedQueue<Integer>();
        GenericObjectPoolConfig conf = new GenericObjectPoolConfig();
        conf.setMaxWaitMillis((long)communicationOptions.getConnectTimeoutMillis());
        conf.setMaxTotal(communicationOptions.getMaxTotalConnections());
        conf.setMaxIdle(communicationOptions.getMaxTotalConnections());
        conf.setMinIdle(communicationOptions.getMinIdleConnections());
        conf.setTestWhileIdle(true);
        conf.setTimeBetweenEvictionRunsMillis(communicationOptions.getTimeBetweenEvictionRunsMillis());
        this.channelFuturePool = new GenericObjectPool((PooledObjectFactory)new ChannelPooledObjectFactory(this, serviceInstance.getIp(), serviceInstance.getPort()), conf);
        try {
            this.channelFuturePool.preparePool();
        }
        catch (Exception ex) {
            log.warn("init min idle object pool failed");
        }
    }

    @Override
    public Channel getChannel() throws Exception, NoSuchElementException, IllegalStateException {
        return (Channel)this.channelFuturePool.borrowObject();
    }

    @Override
    public void returnChannel(Channel channel) {
        try {
            this.channelFuturePool.returnObject((Object)channel);
        }
        catch (Exception e) {
            log.debug("return channel failed:{}", (Object)e.getMessage());
        }
    }

    @Override
    public void removeChannel(Channel channel) {
        try {
            this.channelFuturePool.invalidateObject((Object)channel);
        }
        catch (Exception e) {
            log.debug("remove channel failed:{}", (Object)e.getMessage());
        }
    }

    @Override
    public void close() {
        this.channelFuturePool.close();
    }

    @Override
    public long getFailedNum() {
        return this.failedNum;
    }

    @Override
    public void incFailedNum() {
        ++this.failedNum;
    }

    @Override
    public Queue<Integer> getLatencyWindow() {
        return this.latencyWindow;
    }

    @Override
    public void updateLatency(int latency) {
        this.latencyWindow.add(latency);
        if (this.latencyWindow.size() > this.latencyWindowSize) {
            this.latencyWindow.poll();
        }
    }

    @Override
    public void updateMaxConnection(int num) {
        this.channelFuturePool.setMaxTotal(num);
        this.channelFuturePool.setMaxIdle(num);
    }

    @Override
    public int getCurrentMaxConnection() {
        return this.channelFuturePool.getMaxTotal();
    }

    @Override
    public int getActiveConnectionNum() {
        return this.channelFuturePool.getNumActive();
    }

    @Override
    public int getIdleConnectionNum() {
        return this.channelFuturePool.getNumIdle();
    }

    @Override
    public void updateLatencyWithReadTimeOut() {
        this.updateLatency(this.readTimeOut);
    }
}

