/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.channel;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.CommunicationOptions;
import com.baidu.brpc.client.channel.AbstractBrpcChannel;
import com.baidu.brpc.client.channel.ServiceInstance;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.channel.Channel;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcSingleChannel
extends AbstractBrpcChannel {
    private static final Logger log = LoggerFactory.getLogger(BrpcSingleChannel.class);
    private static final int RETRY_THRESHOLD = 2;
    private volatile Channel channel;
    private volatile Long lastTryConnectTime = 0L;
    private AtomicInteger retryCount = new AtomicInteger(0);
    private int connectPeriod;
    private AtomicLong failedNum = new AtomicLong(0L);
    private int readTimeOut;
    private int latencyWindowSize;
    private Queue<Integer> latencyWindow;
    private static final ExecutorService CONNECTION_SERVICE = Executors.newFixedThreadPool(3, new CustomThreadFactory("single-channel-connect-thread"));

    public BrpcSingleChannel(ServiceInstance serviceInstance, CommunicationOptions communicationOptions) {
        super(serviceInstance, communicationOptions);
        this.connectPeriod = communicationOptions.getHealthyCheckIntervalMillis();
        this.readTimeOut = communicationOptions.getReadTimeoutMillis();
        this.latencyWindowSize = communicationOptions.getLatencyWindowSizeOfFairLoadBalance();
        this.latencyWindow = new ConcurrentLinkedQueue<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel getChannel() throws Exception, NoSuchElementException, IllegalStateException {
        if (this.isNonActive(this.channel)) {
            BrpcSingleChannel brpcSingleChannel = this;
            synchronized (brpcSingleChannel) {
                if (this.isNonActive(this.channel)) {
                    this.channel = this.createChannel(this.serviceInstance.getIp(), this.serviceInstance.getPort());
                }
            }
        }
        return this.channel;
    }

    @Override
    public void removeChannel(Channel channel) {
        if (channel != this.channel) {
            return;
        }
        if (!CONNECTION_SERVICE.isShutdown()) {
            CONNECTION_SERVICE.execute(this.genReconnectTask(channel));
        }
    }

    @Override
    public void updateChannel(Channel channel) {
        if (channel != this.channel) {
            this.channel = channel;
        }
    }

    private ReConnectTask genReconnectTask(Channel oldChannel) {
        return new ReConnectTask(this, oldChannel);
    }

    private Channel createChannel(String ip, int port) {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTryConnectTime < (long)this.connectPeriod && this.retryCount.getAndIncrement() >= 2) {
            return null;
        }
        if (currentTimeMillis - this.lastTryConnectTime >= (long)this.connectPeriod) {
            this.refreshConnectionState(currentTimeMillis, 1);
        }
        Channel channel = this.doCreateChannel(ip, port);
        this.refreshConnectionState(currentTimeMillis, 0);
        return channel;
    }

    private void refreshConnectionState(long currentTimeMillis, int retryCount) {
        this.retryCount = new AtomicInteger(retryCount);
        this.lastTryConnectTime = currentTimeMillis;
    }

    private Channel doCreateChannel(String ip, int port) {
        Channel channel = this.connect();
        ChannelInfo channelInfo = ChannelInfo.getOrCreateClientChannelInfo(channel);
        channelInfo.setProtocol(this.getProtocol());
        channelInfo.setChannelGroup(this);
        return channel;
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public int getCurrentMaxConnection() {
        return this.countChannel();
    }

    @Override
    public int getActiveConnectionNum() {
        return this.countChannel();
    }

    @Override
    public int getIdleConnectionNum() {
        return this.countChannel();
    }

    @Override
    public void returnChannel(Channel channel) {
    }

    @Override
    public void updateMaxConnection(int num) {
    }

    private boolean isActive(Channel channel) {
        return channel != null && channel.isActive();
    }

    private boolean isNonActive(Channel channel) {
        return !this.isActive(channel);
    }

    private int countChannel() {
        return this.isActive(this.channel) ? 1 : 0;
    }

    @Override
    public long getFailedNum() {
        return this.failedNum.get();
    }

    @Override
    public void incFailedNum() {
        this.failedNum.incrementAndGet();
    }

    @Override
    public Queue<Integer> getLatencyWindow() {
        return this.latencyWindow;
    }

    @Override
    public void updateLatency(int latency) {
        this.latencyWindow.add(latency);
        if (this.latencyWindow.size() > this.latencyWindowSize) {
            this.latencyWindow.poll();
        }
    }

    @Override
    public void updateLatencyWithReadTimeOut() {
        this.updateLatency(this.readTimeOut);
    }

    public static class ReConnectTask
    implements Runnable {
        BrpcSingleChannel channelGroup;
        Channel oldChannel;

        public ReConnectTask(BrpcSingleChannel singleChannelGroup, Channel oldChannel) {
            this.channelGroup = singleChannelGroup;
            this.oldChannel = oldChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.oldChannel != this.channelGroup.channel) {
                return;
            }
            if (System.currentTimeMillis() - this.channelGroup.lastTryConnectTime < (long)this.channelGroup.connectPeriod && this.channelGroup.retryCount.get() >= 2) {
                return;
            }
            BrpcSingleChannel brpcSingleChannel = this.channelGroup;
            synchronized (brpcSingleChannel) {
                if (this.oldChannel != this.channelGroup.channel) {
                    return;
                }
                Channel newChannel = null;
                try {
                    newChannel = this.channelGroup.createChannel(this.channelGroup.getServiceInstance().getIp(), this.channelGroup.getServiceInstance().getPort());
                }
                catch (Exception e) {
                    log.info("failed reconnecting");
                }
                if (newChannel != null) {
                    this.channelGroup.updateChannel(newChannel);
                    if (this.oldChannel != null) {
                        this.oldChannel.close();
                    }
                }
            }
        }
    }
}

