/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol;

import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.ProtocolFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolManager {
    private static final Logger log = LoggerFactory.getLogger(ProtocolManager.class);
    private Map<Integer, ProtocolFactory> protocolFactoryMap = new HashMap<Integer, ProtocolFactory>();
    private Map<Integer, Protocol> protocolMap = new HashMap<Integer, Protocol>();
    private List<Protocol> coexistenceProtocols = new ArrayList<Protocol>();
    private int coexistenceProtocolSize = 0;
    private static ProtocolManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProtocolManager getInstance() {
        if (instance != null) return instance;
        Class<ProtocolManager> clazz = ProtocolManager.class;
        synchronized (ProtocolManager.class) {
            if (instance != null) return instance;
            instance = new ProtocolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ProtocolManager() {
    }

    public void registerProtocol(ProtocolFactory protocolFactory, String encoding) {
        Integer protocolType = protocolFactory.getProtocolType();
        if (this.protocolFactoryMap.get(protocolType) != null) {
            throw new RuntimeException("protocol exist, type=" + protocolType);
        }
        Protocol protocol = protocolFactory.createProtocol(encoding);
        this.protocolMap.put(protocolType, protocol);
        this.protocolFactoryMap.put(protocolType, protocolFactory);
        if (protocol.isCoexistence()) {
            this.coexistenceProtocols.add(protocol);
            ++this.coexistenceProtocolSize;
        }
        log.info("register protocol:{} success", (Object)protocolFactory.getProtocolName());
    }

    public Protocol getProtocol(Integer protocolType) {
        Protocol protocol = this.protocolMap.get(protocolType);
        if (protocol != null) {
            return protocol;
        }
        throw new RuntimeException("protocol not exist, type=" + protocolType);
    }

    public Map<Integer, Protocol> getProtocolMap() {
        return this.protocolMap;
    }

    public List<Protocol> getCoexistenceProtocols() {
        return this.coexistenceProtocols;
    }

    public int getCoexistenceProtocolSize() {
        return this.coexistenceProtocolSize;
    }
}

