/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.dubbo;

import com.alibaba.com.caucho.hessian.io.Hessian2Input;
import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.AbstractProtocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcRequest;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.dubbo.DubboConstants;
import com.baidu.brpc.protocol.dubbo.DubboHeader;
import com.baidu.brpc.protocol.dubbo.DubboPacket;
import com.baidu.brpc.protocol.dubbo.DubboRequestBody;
import com.baidu.brpc.protocol.dubbo.DubboResponseBody;
import com.baidu.brpc.server.ServiceManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboRpcProtocol
extends AbstractProtocol {
    private static final Logger log = LoggerFactory.getLogger(DubboRpcProtocol.class);
    protected static final byte FLAG_REQUEST = -128;
    protected static final byte FLAG_TWOWAY = 64;
    protected static final byte FLAG_EVENT = 32;
    private static final NotEnoughDataException notEnoughDataException = new NotEnoughDataException("not enough data");
    private ServiceManager serviceManager = ServiceManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws TooBigDataException, NotEnoughDataException, BadSchemaException {
        if (in.readableBytes() < 16) {
            throw notEnoughDataException;
        }
        ByteBuf headerBuf = in.retainedSlice(16);
        try {
            DubboHeader dubboHeader = DubboHeader.decode(headerBuf);
            if (dubboHeader.getMagic() != -9541) {
                throw new BadSchemaException("not valid magic head for dubbo");
            }
            if (dubboHeader.getBodyLength() > 0x20000000) {
                throw new TooBigDataException("dubbo too big body size:" + dubboHeader.getBodyLength());
            }
            if (in.readableBytes() < dubboHeader.getBodyLength() + 16) {
                throw notEnoughDataException;
            }
            in.skipBytes(16);
            ByteBuf bodyBuf = in.readRetainedSlice(dubboHeader.getBodyLength());
            DubboPacket dubboPacket = new DubboPacket();
            dubboPacket.setHeader(dubboHeader);
            dubboPacket.setBodyBuf(bodyBuf);
            DubboPacket dubboPacket2 = dubboPacket;
            return dubboPacket2;
        }
        finally {
            headerBuf.release();
        }
    }

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        DubboHeader header = new DubboHeader();
        byte flag = (byte)(0xFFFFFF80 | this.getContentTypeId());
        if (!request.isOneWay()) {
            flag = (byte)(flag | 0x40);
        }
        if (request.isHeartbeat()) {
            flag = (byte)(flag | 0x20);
        }
        header.setFlag(flag);
        header.setCorrelationId(request.getCorrelationId());
        byte[] bodyBytes = null;
        if (request.isHeartbeat()) {
            bodyBytes = DubboPacket.encodeHeartbeatBody();
        } else {
            DubboRequestBody requestBody = new DubboRequestBody();
            requestBody.setPath(request.getServiceName());
            requestBody.setVersion(request.getSubscribeInfo().getVersion());
            requestBody.setMethodName(request.getMethodName());
            requestBody.setParameterTypes(request.getTargetMethod().getParameterTypes());
            requestBody.setArguments(request.getArgs());
            HashMap<String, String> kvAttachments = new HashMap<String, String>();
            kvAttachments.put("group", request.getSubscribeInfo().getGroup());
            if (request.getKvAttachment() != null) {
                for (Map.Entry<String, Object> entry : request.getKvAttachment().entrySet()) {
                    kvAttachments.put(entry.getKey(), (String)entry.getValue());
                }
            }
            requestBody.setAttachments(kvAttachments);
            bodyBytes = requestBody.encodeRequestBody();
        }
        header.setBodyLength(bodyBytes.length);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header.encode(), Unpooled.wrappedBuffer((byte[])bodyBytes)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Response decodeResponse(Object msg, ChannelHandlerContext ctx) throws Exception {
        RpcResponse response = new RpcResponse();
        DubboPacket dubboPacket = (DubboPacket)msg;
        DubboHeader dubboHeader = dubboPacket.getHeader();
        response.setCorrelationId(dubboHeader.getCorrelationId());
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
        RpcFuture future = channelInfo.removeRpcFuture(response.getCorrelationId());
        if (future == null) {
            return response;
        }
        response.setRpcFuture(future);
        byte status = dubboHeader.getStatus();
        if (status == 20) {
            if ((dubboHeader.getFlag() & 0x20) != 0) {
                Object bodyObject = DubboPacket.decodeEventBody(dubboPacket.getBodyBuf());
                if (bodyObject != DubboConstants.HEARTBEAT_EVENT) throw new RpcException("response body not null for event");
                response.setHeartbeat(true);
                return response;
            } else {
                DubboResponseBody responseBody = DubboResponseBody.decodeResponseBody(dubboPacket.getBodyBuf());
                response.setResult(responseBody.getResult());
                response.setException(responseBody.getException());
                if (responseBody.getAttachments() == null) return response;
                HashMap<String, Object> attachments = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry : responseBody.getAttachments().entrySet()) {
                    attachments.put(entry.getKey(), entry.getValue());
                }
                response.setKvAttachment(attachments);
            }
            return response;
        }
        ByteBufInputStream inputStream = null;
        try {
            inputStream = new ByteBufInputStream(dubboPacket.getBodyBuf(), true);
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)inputStream);
            String errorString = hessian2Input.readString();
            response.setException(new RpcException(3, errorString));
            return response;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public Request decodeRequest(Object packet) throws Exception {
        RpcRequest request = new RpcRequest();
        DubboPacket dubboPacket = (DubboPacket)packet;
        request.setCorrelationId(dubboPacket.getHeader().getCorrelationId());
        byte flag = dubboPacket.getHeader().getFlag();
        if ((flag & 0x20) != 0) {
            Object bodyObject = DubboPacket.decodeEventBody(dubboPacket.getBodyBuf());
            if (bodyObject != DubboConstants.HEARTBEAT_EVENT) {
                throw new RpcException("request body not null for event");
            }
            request.setHeartbeat(true);
            return request;
        }
        try {
            DubboRequestBody dubboRequestBody = DubboRequestBody.decodeRequestBody(dubboPacket.getBodyBuf());
            request.setArgs(dubboRequestBody.getArguments());
            request.setMethodName(dubboRequestBody.getPath());
            request.setRpcMethodInfo(dubboRequestBody.getRpcMethodInfo());
            request.setTarget(dubboRequestBody.getRpcMethodInfo().getTarget());
            request.setTargetMethod(dubboRequestBody.getRpcMethodInfo().getMethod());
            if (dubboRequestBody.getAttachments().size() > 0) {
                HashMap<String, Object> attachments = new HashMap<String, Object>(dubboRequestBody.getAttachments().size());
                for (Map.Entry<String, String> entry : dubboRequestBody.getAttachments().entrySet()) {
                    attachments.put(entry.getKey(), entry.getValue());
                }
                request.setKvAttachment(attachments);
            }
            return request;
        }
        catch (Exception e) {
            log.error("dubbo decodeRequest error at {} ", (Object)e.getMessage(), (Object)e);
            throw new RpcException("dubbo decodeRequest error", (Throwable)e);
        }
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        try {
            DubboHeader dubboHeader = new DubboHeader();
            DubboResponseBody responseBody = new DubboResponseBody();
            dubboHeader.setFlag(this.getContentTypeId());
            if (request.isHeartbeat()) {
                dubboHeader.setFlag((byte)(dubboHeader.getFlag() | 0x20));
            }
            dubboHeader.setCorrelationId(response.getCorrelationId());
            if (response.getException() != null) {
                dubboHeader.setStatus((byte)70);
                byte[] bodyBytes = DubboResponseBody.encodeErrorResponseBody(response.getException().getMessage());
                dubboHeader.setBodyLength(bodyBytes.length);
                return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{dubboHeader.encode(), Unpooled.wrappedBuffer((byte[])bodyBytes)});
            }
            dubboHeader.setStatus((byte)20);
            if (request.isHeartbeat()) {
                byte[] bodyBytes = DubboResponseBody.encodeHeartbeatResponseBody();
                dubboHeader.setBodyLength(bodyBytes.length);
                return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{dubboHeader.encode(), Unpooled.wrappedBuffer((byte[])bodyBytes)});
            }
            responseBody.setResult(response.getResult());
            if (response.getKvAttachment() != null && response.getKvAttachment().size() > 0) {
                responseBody.setResponseType((byte)4);
                HashMap<String, String> attachments = new HashMap<String, String>();
                for (Map.Entry<String, Object> entry : response.getKvAttachment().entrySet()) {
                    attachments.put(entry.getKey(), (String)entry.getValue());
                }
                responseBody.setAttachments(attachments);
            } else {
                responseBody.setResponseType((byte)1);
            }
            byte[] bodyBytes = responseBody.encodeResponseBody();
            dubboHeader.setBodyLength(bodyBytes.length);
            return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{dubboHeader.encode(), Unpooled.wrappedBuffer((byte[])bodyBytes)});
        }
        catch (Exception e) {
            log.warn("encode response failed", (Throwable)e);
            throw new RpcException(5, (Throwable)e);
        }
    }

    @Override
    public boolean supportHeartbeat() {
        return true;
    }

    protected byte getContentTypeId() {
        return 2;
    }
}

