/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.JprotobufRpcMethodInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcContext;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.AsyncAwareFuture;
import com.baidu.brpc.client.CommunicationClient;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.Options;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.nshead.NSHead;
import com.baidu.brpc.protocol.nshead.NSHeadMeta;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.ChannelManager;
import com.baidu.brpc.server.CommunicationServer;
import com.baidu.brpc.utils.ProtobufUtils;
import io.netty.channel.Channel;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcPushProxy
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrpcPushProxy.class);
    private static final Set<String> notProxyMethodSet = new HashSet<String>();
    private CommunicationServer rpcServer;
    private static Map<String, RpcMethodInfo> rpcMethodMap;

    protected BrpcPushProxy(CommunicationServer rpcServer, Class clazz) {
        Method[] methods;
        this.rpcServer = rpcServer;
        if (!(rpcServer.getProtocol() instanceof ServerPushProtocol)) {
            throw new RpcException(" server protocol should be serverPushProtocl");
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Method syncMethod;
            if (notProxyMethodSet.contains(method.getName())) {
                log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
                continue;
            }
            Object[] oriTypes = method.getParameterTypes();
            if (oriTypes.length < 1) {
                throw new IllegalArgumentException("number of arguments cannot be zero");
            }
            if (!String.class.isAssignableFrom(oriTypes[0])) {
                throw new IllegalArgumentException("first arguments must be clientName (String)");
            }
            if (Future.class.isAssignableFrom(method.getReturnType()) && !RpcCallback.class.isAssignableFrom((Class<?>)oriTypes[oriTypes.length - 1])) {
                throw new IllegalArgumentException("returnType is Future, but last argument is not RpcCallback");
            }
            Object[] paramTypesExcludeClientName = (Class[])ArrayUtils.subarray((Object[])oriTypes, (int)1, (int)oriTypes.length);
            int paramLengthExcludeClientName = paramTypesExcludeClientName.length;
            Object[] actualArgTypes = paramTypesExcludeClientName;
            if (paramLengthExcludeClientName >= 1 && RpcCallback.class.isAssignableFrom(paramTypesExcludeClientName[paramLengthExcludeClientName - 1])) {
                actualArgTypes = (Class[])ArrayUtils.subarray((Object[])paramTypesExcludeClientName, (int)0, (int)(paramTypesExcludeClientName.length - 1));
            }
            try {
                syncMethod = method.getDeclaringClass().getMethod(method.getName(), (Class<?>[])actualArgTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("can not find sync method:" + method.getName());
            }
            ProtobufUtils.MessageType messageType = ProtobufUtils.getMessageType(syncMethod);
            RpcMethodInfo methodInfo = messageType == ProtobufUtils.MessageType.PROTOBUF ? new ProtobufRpcMethodInfo(syncMethod) : (messageType == ProtobufUtils.MessageType.JPROTOBUF ? new JprotobufRpcMethodInfo(syncMethod) : new RpcMethodInfo(syncMethod));
            rpcMethodMap.put(method.getName(), methodInfo);
            log.debug("client serviceName={}, methodName={}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        }
    }

    public static <T> T getProxy(CommunicationServer rpcServer, Class clazz) {
        Enhancer en = new Enhancer();
        en.setSuperclass(clazz);
        en.setCallback((Callback)new BrpcPushProxy(rpcServer, clazz));
        return (T)en.create();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Validate.notNull((Object)this.rpcServer);
        String methodName = method.getName();
        RpcMethodInfo rpcMethodInfo = rpcMethodMap.get(methodName);
        if (rpcMethodInfo == null) {
            log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)methodName);
            return proxy.invokeSuper(obj, args);
        }
        int argLength = args.length;
        List<Object> argList = Arrays.asList(args);
        argList = argList.subList(1, argLength);
        argLength = argList.size();
        Object[] actualArgs = argList.toArray();
        Request request = null;
        Response response = null;
        Object interceptors = null;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        request = this.rpcServer.getProtocol().createRequest();
        response = this.rpcServer.getProtocol().getResponse();
        request.setClientName((String)args[0]);
        SPHead spHead = ((ServerPushProtocol)this.rpcServer.getProtocol()).createSPHead();
        spHead.setType(2);
        request.setSpHead(spHead);
        request.setCompressType(Options.CompressType.COMPRESS_TYPE_NONE.getNumber());
        try {
            request.setTarget(obj);
            request.setRpcMethodInfo(rpcMethodInfo);
            request.setTargetMethod(rpcMethodInfo.getMethod());
            request.setServiceName(rpcMethodInfo.getServiceName());
            request.setMethodName(rpcMethodInfo.getMethodName());
            NSHeadMeta nsHeadMeta = rpcMethodInfo.getNsHeadMeta();
            NSHead nsHead = nsHeadMeta == null ? new NSHead() : new NSHead(0, nsHeadMeta.id(), nsHeadMeta.version(), nsHeadMeta.provider(), 0);
            request.setNsHead(nsHead);
            RpcCallback callback = null;
            if (argLength > 1) {
                int startIndex = 0;
                int endIndex = argLength - 1;
                if (actualArgs[endIndex] instanceof RpcCallback) {
                    callback = (RpcCallback)actualArgs[endIndex];
                    --endIndex;
                    --argLength;
                }
                if (argLength <= 0) {
                    throw new RpcException(0, "invalid params");
                }
                Object[] sendArgs = new Object[argLength];
                int i = 0;
                while (startIndex <= endIndex) {
                    sendArgs[i] = actualArgs[startIndex++];
                    ++i;
                }
                request.setArgs(sendArgs);
                request.setCallback(callback);
            } else {
                request.setArgs(actualArgs);
            }
            if (RpcContext.isSet()) {
                RpcContext rpcContext = RpcContext.getContext();
                if (rpcContext.getRequestKvAttachment() != null) {
                    request.setKvAttachment(rpcContext.getRequestKvAttachment());
                }
                if (rpcContext.getRequestBinaryAttachment() != null) {
                    request.setBinaryAttachment(rpcContext.getRequestBinaryAttachment());
                }
                if (rpcContext.getLogId() != null) {
                    request.getNsHead().logId = rpcContext.getLogId().intValue();
                }
                if (rpcContext.getServiceTag() != null) {
                    request.setServiceTag(rpcContext.getServiceTag());
                }
                if (rpcContext.getReadTimeoutMillis() != null) {
                    request.setReadTimeoutMillis(rpcContext.getReadTimeoutMillis());
                }
                if (rpcContext.getWriteTimeoutMillis() != null) {
                    request.setWriteTimeoutMillis(rpcContext.getWriteTimeoutMillis());
                }
                rpcContext.reset();
            }
            if (request.getReadTimeoutMillis() == null) {
                request.setReadTimeoutMillis(readTimeout);
            }
            if (request.getWriteTimeoutMillis() == null) {
                request.setWriteTimeoutMillis(writeTimeout);
            }
            try {
                this.executeWithRetry(request, response);
                if (response.getException() != null) {
                    throw new RpcException(response.getException());
                }
                if (request.getCallback() != null) {
                    RpcFuture rpcContext = response.getRpcFuture();
                    return rpcContext;
                }
                Object rpcContext = response.getResult();
                return rpcContext;
            }
            catch (Exception ex) {
                log.error("exception :", (Throwable)ex);
                throw new RpcException(response.getException());
            }
        }
        finally {
            if (request != null) {
                request.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithRetry(Request request, Response response) {
        RpcException exception = null;
        int currentTryTimes = 0;
        int maxTryTimes = this.rpcServer.getRpcServerOptions().getMaxTryTimes();
        while (currentTryTimes < maxTryTimes) {
            try {
                if (currentTryTimes > 0 && request.getChannel() != null) {
                    if (request.getSelectedInstances() == null) {
                        request.setSelectedInstances(new HashSet<CommunicationClient>(maxTryTimes - 1));
                    }
                    request.getSelectedInstances().add(request.getCommunicationClient());
                }
                this.selectChannel(request);
                this.pushCore(request, response);
                break;
            }
            catch (RpcException ex) {
                exception = ex;
                if (exception.getCode() != 6) continue;
                break;
            }
            finally {
                ++currentTryTimes;
            }
        }
        if (response.getResult() == null && response.getRpcFuture() == null) {
            if (exception == null) {
                exception = new RpcException(0, "unknown error");
            }
            throw exception;
        }
    }

    protected Channel selectChannel(Request request) {
        String clientName;
        ChannelManager channelManager = ChannelManager.getInstance();
        Channel channel = channelManager.getChannel(clientName = request.getClientName());
        if (channel == null) {
            log.error("cannot find a valid channel by name:" + clientName);
            throw new RpcException("cannot find a valid channel by name:" + clientName);
        }
        request.setChannel(channel);
        return channel;
    }

    protected void pushCore(Request request, Response response) throws RpcException {
        AsyncAwareFuture future = this.rpcServer.sendServerPush(request);
        if (future.isAsync()) {
            response.setRpcFuture((RpcFuture)future);
        } else {
            try {
                Object result = future.get(request.getReadTimeoutMillis().intValue(), TimeUnit.MILLISECONDS);
                response.setResult(result);
            }
            catch (Exception ex) {
                response.setException(new RpcException(2, "timeout"));
            }
        }
    }

    public Map<String, RpcMethodInfo> getRpcMethodMap() {
        return rpcMethodMap;
    }

    static {
        notProxyMethodSet.add("getClass");
        notProxyMethodSet.add("hashCode");
        notProxyMethodSet.add("equals");
        notProxyMethodSet.add("clone");
        notProxyMethodSet.add("toString");
        notProxyMethodSet.add("notify");
        notProxyMethodSet.add("notifyAll");
        notProxyMethodSet.add("wait");
        notProxyMethodSet.add("finalize");
        rpcMethodMap = new HashMap<String, RpcMethodInfo>();
    }
}

