/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.server.CommunicationServer;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.utils.ThreadPool;
import java.util.Map;

public class ServerStatus {
    private static final int SECONDS_IN_HOUR = 3600;
    private static final int SECONDS_IN_DAY = 86400;
    private long startTime;
    private CommunicationServer server;

    public ServerStatus(CommunicationServer server) {
        this.server = server;
        this.startTime = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head>");
        ret.append("Server online: ").append(this.getOnlineDuration(this.startTime)).append("<br>");
        ret.append("RPC port:").append(this.server.getPort()).append("<br>");
        ret.append("Http management port:").append(this.server.getPort()).append("<br>");
        ret.append("Compress enabled(Gzip Snappy)").append("<br>");
        ret.append("Attachment enabled").append("<br>");
        ThreadPool.StatInfo threadPoolInfo = this.server.getThreadPool().getStatInfo();
        ret.append("--------------Thread status----------------").append("<br>");
        ret.append("Thread count:").append(threadPoolInfo.getThreadNum()).append("<br>");
        ret.append("Queue capacity:").append(threadPoolInfo.getDefaultQueueCapacity()).append("<br>");
        ret.append("Producer queue size:").append(threadPoolInfo.getProducerQueueSize()).append("<br>");
        ret.append("Consumer queue size:").append(threadPoolInfo.getConsumerQueueSize()).append("<br>");
        ret.append("<br>").append("<br>");
        ret.append("<pre>");
        ret.append("--------------properties info(").append(RpcServerOptions.class.getDeclaredFields().length).append(")----------------").append("<br>");
        ret.append(this.server.getRpcServerOptions());
        ret.append("<br>").append("<br>");
        ServiceManager serviceManager = ServiceManager.getInstance();
        Map<String, RpcMethodInfo> serviceMap = serviceManager.getServiceMap();
        ret.append("--------------RPC service list(").append(serviceMap.size()).append(") ----------------").append("<br>");
        for (Map.Entry<String, RpcMethodInfo> entry : serviceMap.entrySet()) {
            ret.append("<B>").append("Service name:").append(entry.getValue().getServiceName()).append("<br>");
            ret.append("Method name:").append(entry.getValue().getMethodName()).append("</B>").append("<br>");
            ret.append("Request IDL:").append("<br>").append(((Class)entry.getValue().getInputClasses()[0]).getName()).append("<br>");
            ret.append("Response IDL:").append("<br>").append(((Class)entry.getValue().getOutputClass()).getName()).append("<br>");
            ret.append("<br>");
        }
        ret.append("<br>").append("<br>");
        return ret.toString();
    }

    private String getOnlineDuration(long startTime) {
        StringBuilder ret = new StringBuilder();
        long ms = (System.currentTimeMillis() - startTime) / 1000L;
        long days = ms / 86400L;
        long hours = ms % 86400L / 3600L;
        long seconds = ms % 86400L % 3600L;
        ret.append(days).append(" days ").append(hours).append(" hours ").append(seconds).append(" seconds");
        return ret.toString();
    }
}

