/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming.consul.client;

import com.baidu.brpc.naming.consul.client.ConsulClientTokenExt;
import com.baidu.brpc.naming.consul.client.ConsulClientTokenExtImpl;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Member;
import com.ecwid.consul.v1.agent.model.NewCheck;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.agent.model.Self;
import com.ecwid.consul.v1.agent.model.Service;
import com.ecwid.consul.v1.catalog.model.CatalogService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.Check;
import com.ecwid.consul.v1.health.model.HealthService;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import com.ecwid.consul.v1.session.model.NewSession;
import com.ecwid.consul.v1.session.model.Session;
import java.util.List;
import java.util.Map;

public class ConsulClientExt
extends ConsulClient {
    protected ConsulRawClient rawClient;
    protected String token;
    protected ConsulClientTokenExt clientTokenExt;

    public ConsulClientExt(ConsulRawClient rawClient, String token) {
        super(rawClient);
        this.rawClient = rawClient;
        this.token = token;
        this.clientTokenExt = new ConsulClientTokenExtImpl(rawClient);
    }

    public Response<Self> getAgentSelf() {
        return super.getAgentSelf(this.token);
    }

    public Response<Map<String, com.ecwid.consul.v1.agent.model.Check>> getAgentChecks() {
        return this.clientTokenExt.getAgentChecks(this.token);
    }

    public Response<Map<String, Service>> getAgentServices() {
        return this.clientTokenExt.getAgentServices(this.token);
    }

    public Response<List<Member>> getAgentMembers() {
        return this.clientTokenExt.getAgentMembers(this.token);
    }

    public Response<Void> agentCheckRegister(NewCheck newCheck) {
        return super.agentCheckRegister(newCheck, this.token);
    }

    public Response<Void> agentCheckDeregister(String checkId) {
        return super.agentCheckDeregister(checkId, this.token);
    }

    public Response<Void> agentServiceRegister(NewService newService) {
        return super.agentServiceRegister(newService, this.token);
    }

    public Response<Void> agentServiceDeregister(String serviceId) {
        return super.agentServiceDeregister(serviceId, this.token);
    }

    public Response<Void> agentCheckPass(String checkId) {
        return super.agentCheckPass(checkId, null, this.token);
    }

    public Response<Void> agentServiceSetMaintenance(String serviceId, boolean maintenanceEnabled) {
        return this.clientTokenExt.agentServiceSetMaintenance(serviceId, maintenanceEnabled, null, this.token);
    }

    public Response<Boolean> setKVValue(String key, String value) {
        return this.setKVValue(key, value, this.token, null, QueryParams.DEFAULT);
    }

    public Response<Boolean> setKVValue(String key, String value, PutParams putParams) {
        return super.setKVValue(key, value, this.token, putParams);
    }

    public Response<Void> deleteKVValue(String key) {
        return super.deleteKVValue(key, this.token);
    }

    public Response<GetValue> getKVValue(String key) {
        return super.getKVValue(key, this.token);
    }

    public Response<String> sessionCreate(NewSession newSession, QueryParams queryParams) {
        return super.sessionCreate(newSession, queryParams, this.token);
    }

    public Response<Void> sessionDestroy(String session, QueryParams queryParams) {
        return super.sessionDestroy(session, queryParams, this.token);
    }

    public Response<Session> renewSession(String session, QueryParams queryParams) {
        return super.renewSession(session, queryParams, this.token);
    }

    public Response<Map<String, List<String>>> getCatalogServices(QueryParams queryParams) {
        return super.getCatalogServices(queryParams, this.token);
    }

    public Response<List<CatalogService>> getCatalogService(String serviceName, QueryParams queryParams) {
        return super.getCatalogService(serviceName, queryParams, this.token);
    }

    public Response<List<HealthService>> getHealthServices(String serviceName, boolean onlyPassing, QueryParams queryParams) {
        return super.getHealthServices(serviceName, onlyPassing, queryParams, this.token);
    }

    public Response<List<HealthService>> getHealthServices(String serviceName, String tag, boolean onlyPassing, QueryParams queryParams) {
        return super.getHealthServices(serviceName, tag, onlyPassing, queryParams, this.token);
    }

    public Response<List<HealthService>> getHealthServices(String serviceName, HealthServicesRequest healthRequest) {
        HealthServicesRequest req = HealthServicesRequest.newBuilder().setDatacenter(healthRequest.getDatacenter()).setNear(healthRequest.getNear()).setTag(healthRequest.getTag()).setNodeMeta(healthRequest.getNodeMeta()).setPassing(healthRequest.isPassing()).setQueryParams(healthRequest.getQueryParams()).setToken(healthRequest.getToken() != null ? healthRequest.getToken() : this.token).build();
        return super.getHealthServices(serviceName, req);
    }

    public Response<List<Check>> getHealthChecksForService(String serviceName, QueryParams queryParams) {
        return this.clientTokenExt.getHealthChecksForService(serviceName, queryParams, this.token);
    }

    public Response<String> getStatusLeader() {
        return this.clientTokenExt.getStatusLeader(this.token);
    }

    public Response<List<String>> getStatusPeers() {
        return this.clientTokenExt.getStatusPeers(this.token);
    }
}

