/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming.consul.client;

import com.baidu.brpc.naming.consul.client.ConsulClientTokenExt;
import com.ecwid.consul.SingleUrlParameters;
import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.Member;
import com.ecwid.consul.v1.agent.model.Service;
import com.ecwid.consul.v1.health.HealthChecksForServiceRequest;
import com.ecwid.consul.v1.health.model.Check;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class ConsulClientTokenExtImpl
implements ConsulClientTokenExt {
    private ConsulRawClient rawClient;

    public ConsulClientTokenExtImpl(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    @Override
    public Response<Map<String, com.ecwid.consul.v1.agent.model.Check>> getAgentChecks(String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/checks", new UrlParameters[]{tokenParam});
        if (rawResponse.getStatusCode() == 200) {
            Map value = (Map)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<Map<String, com.ecwid.consul.v1.agent.model.Check>>(){}.getType());
            return new Response((Object)value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Map<String, Service>> getAgentServices(String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/services", new UrlParameters[]{tokenParam});
        if (rawResponse.getStatusCode() == 200) {
            Map agentServices = (Map)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<Map<String, Service>>(){}.getType());
            return new Response((Object)agentServices, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Member>> getAgentMembers(String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/agent/members", new UrlParameters[]{tokenParam});
        if (rawResponse.getStatusCode() == 200) {
            List members = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Member>>(){}.getType());
            return new Response((Object)members, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<Void> agentServiceSetMaintenance(String serviceId, boolean maintenanceEnabled, String reason, String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        SingleUrlParameters maintenanceParameter = new SingleUrlParameters("enable", Boolean.toString(maintenanceEnabled));
        SingleUrlParameters reasonParameter = reason != null ? new SingleUrlParameters("reason", reason) : null;
        RawResponse rawResponse = this.rawClient.makePutRequest("/v1/agent/service/maintenance/" + serviceId, "", new UrlParameters[]{maintenanceParameter, reasonParameter, tokenParam});
        if (rawResponse.getStatusCode() == 200) {
            return new Response(null, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<String> getStatusLeader(String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/status/leader", new UrlParameters[]{tokenParam});
        if (rawResponse.getStatusCode() == 200) {
            String value = (String)GsonFactory.getGson().fromJson(rawResponse.getContent(), String.class);
            return new Response((Object)value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<String>> getStatusPeers(String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/status/peers", new UrlParameters[]{tokenParam});
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<String>>(){}.getType());
            return new Response((Object)value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Check>> getHealthChecksForService(String serviceName, QueryParams queryParams, String token) {
        SingleUrlParameters tokenParam = token != null ? new SingleUrlParameters("token", token) : null;
        HealthChecksForServiceRequest request = HealthChecksForServiceRequest.newBuilder().setQueryParams(queryParams).build();
        List urlParameters = request.asUrlParameters();
        urlParameters.add(tokenParam);
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/health/checks/" + serviceName, urlParameters);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Check>>(){}.getType());
            return new Response((Object)value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

