/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.client.instance.ServiceInstance;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NotifyListener;
import com.baidu.brpc.naming.RegisterInfo;
import com.baidu.brpc.naming.SubscribeInfo;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;

public class DnsNamingService
implements NamingService {
    private BrpcURL namingUrl;
    private String host;
    private int port;
    private String hostPort;
    private List<ServiceInstance> lastInstances = new ArrayList<ServiceInstance>();
    private Timer namingServiceTimer;
    private int updateInterval;

    public DnsNamingService(BrpcURL namingUrl) {
        Validate.notNull((Object)namingUrl);
        Validate.notEmpty((CharSequence)namingUrl.getHostPorts());
        this.namingUrl = namingUrl;
        String[] splits = namingUrl.getHostPorts().split(":");
        this.host = splits[0];
        this.port = splits.length == 2 ? Integer.valueOf(splits[1]) : 80;
        this.hostPort = this.host + ":" + this.port;
        this.updateInterval = namingUrl.getIntParameter("interval", 5000);
        this.namingServiceTimer = new HashedWheelTimer((ThreadFactory)new CustomThreadFactory("namingService-timer-thread"));
    }

    @Override
    public List<ServiceInstance> lookup(SubscribeInfo subscribeInfo) {
        InetAddress[] addresses;
        try {
            addresses = InetAddress.getAllByName(this.host);
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException("unknown http host");
        }
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (InetAddress address : addresses) {
            ServiceInstance instance = new ServiceInstance(address.getHostAddress(), this.port);
            instances.add(instance);
        }
        return instances;
    }

    @Override
    public void subscribe(SubscribeInfo subscribeInfo, final NotifyListener listener) {
        this.namingServiceTimer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                try {
                    List<ServiceInstance> currentInstances = DnsNamingService.this.lookup(null);
                    Collection addList = CollectionUtils.subtract(currentInstances, (Iterable)DnsNamingService.this.lastInstances);
                    Collection deleteList = CollectionUtils.subtract((Iterable)DnsNamingService.this.lastInstances, currentInstances);
                    listener.notify(addList, deleteList);
                    DnsNamingService.this.lastInstances = currentInstances;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DnsNamingService.this.namingServiceTimer.newTimeout((TimerTask)this, (long)DnsNamingService.this.updateInterval, TimeUnit.MILLISECONDS);
            }
        }, (long)this.updateInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unsubscribe(SubscribeInfo subscribeInfo) {
        this.namingServiceTimer.stop();
    }

    @Override
    public void register(RegisterInfo registerInfo) {
    }

    @Override
    public void unregister(RegisterInfo registerInfo) {
    }

    public String getHostPort() {
        return this.hostPort;
    }

    @Override
    public void destroy() {
    }
}

