/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.push.impl;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.buffer.DynamicCompositeByteBuf;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.exceptions.BadSchemaException;
import com.baidu.brpc.exceptions.NotEnoughDataException;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.exceptions.TooBigDataException;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.RpcRequest;
import com.baidu.brpc.protocol.RpcResponse;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.protocol.push.impl.DefaultSPHead;
import com.baidu.brpc.protocol.push.impl.DefaultServerPushPacket;
import com.baidu.brpc.protocol.push.impl.SPBody;
import com.baidu.brpc.server.PushServerRpcFutureManager;
import com.baidu.brpc.server.ServiceManager;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtobufIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerPushProtocol
implements ServerPushProtocol {
    private static final Logger log = LoggerFactory.getLogger(DefaultServerPushProtocol.class);
    protected String encoding = "utf-8";

    public DefaultServerPushProtocol(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    @Override
    public ByteBuf encodeRequest(Request request) throws Exception {
        Validate.notEmpty((Object[])request.getArgs(), (String)"args must not be empty", (Object[])new Object[0]);
        ByteBuf bodyBuf = this.encodeRequestBody(request, request.getRpcMethodInfo());
        DefaultSPHead spHead = (DefaultSPHead)request.getSpHead();
        Validate.notNull((Object)bodyBuf);
        spHead.bodyLength = bodyBuf.readableBytes();
        spHead.logId = request.getLogId();
        spHead.setCorrelationId(request.getCorrelationId());
        ByteBuf headerBuf = this.headToBytes(spHead);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, bodyBuf});
    }

    @Override
    public void beforeRequestSent(Request request, RpcClient rpcClient, BrpcChannel channelGroup) {
    }

    @Override
    public Response decodeServerPushResponse(Object in, ChannelHandlerContext ctx) {
        DefaultServerPushPacket packet = (DefaultServerPushPacket)in;
        RpcResponse rpcResponse = new RpcResponse();
        Long correlationId = packet.getSpHead().getCorrelationId();
        RpcFuture future = PushServerRpcFutureManager.getInstance().removeRpcFuture(correlationId);
        rpcResponse.setCorrelationId(correlationId);
        if (future == null) {
            return rpcResponse;
        }
        rpcResponse.setRpcFuture(future);
        ByteBuf bodyBuf = packet.getBodyBuf();
        SPBody spBody = this.decodeBodyByteBuf(bodyBuf);
        Object responseBody = spBody.getContent();
        if (responseBody == null) {
            return null;
        }
        rpcResponse.setResult(responseBody);
        return rpcResponse;
    }

    @Override
    public Response decodeResponse(Object in, ChannelHandlerContext ctx) throws Exception {
        DefaultServerPushPacket packet = (DefaultServerPushPacket)in;
        RpcResponse rpcResponse = new RpcResponse();
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(ctx.channel());
        Long correlationId = packet.getSpHead().getCorrelationId();
        rpcResponse.setCorrelationId(correlationId);
        RpcFuture future = channelInfo.removeRpcFuture(rpcResponse.getCorrelationId());
        if (future == null || future.getRpcMethodInfo() == null) {
            try {
                ByteBuf byteBuf = packet.getBodyBuf();
                byteBuf.release();
            }
            catch (Exception e) {
                throw new RpcException(e);
            }
            return rpcResponse;
        }
        rpcResponse.setRpcFuture(future);
        SPBody spBody = this.decodeBodyByteBuf(packet.getBodyBuf());
        Object responseBody = spBody.getContent();
        if (responseBody == null) {
            return null;
        }
        rpcResponse.setResult(responseBody);
        return rpcResponse;
    }

    @Override
    public ByteBuf encodeResponse(Request request, Response response) throws Exception {
        ByteBuf bodyBuf = this.encodeResponseBody(response.getResult(), response.getRpcMethodInfo());
        DefaultSPHead spHead = (DefaultSPHead)response.getSpHead();
        if (spHead == null) {
            spHead = new DefaultSPHead((int)response.getCorrelationId(), bodyBuf.readableBytes());
        } else {
            spHead.bodyLength = bodyBuf.readableBytes();
        }
        spHead.correlationId = response.getCorrelationId();
        switch (request.getSpHead().getType()) {
            case 2: {
                spHead.type = 3;
                break;
            }
            case 4: {
                spHead.type = 5;
                break;
            }
            default: {
                spHead.type = 1;
            }
        }
        ByteBuf headerBuf = this.headToBytes(spHead);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, bodyBuf});
    }

    @Override
    public void afterResponseSent(Request request, Response response, ChannelFuture channelFuture) {
    }

    @Override
    public Request decodeRequest(Object packet) throws Exception {
        Request request = this.createRequest();
        DefaultServerPushPacket spPacket = (DefaultServerPushPacket)packet;
        ByteBuf bodyBuf = ((DefaultServerPushPacket)packet).getBodyBuf();
        request.setLogId(spPacket.getSpHead().getLogId());
        request.setCorrelationId(spPacket.getSpHead().getCorrelationId());
        request.setSpHead(((DefaultServerPushPacket)packet).getSpHead());
        if (request.getSpHead().getType() == 4) {
            request.setOneWay(true);
        }
        SPBody spBody = this.decodeBodyByteBuf(bodyBuf);
        this.decodeRequestBody(spBody, request);
        return request;
    }

    @Override
    public boolean returnChannelBeforeResponse() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultServerPushPacket decode(ChannelHandlerContext ctx, DynamicCompositeByteBuf in, boolean isDecodingRequest) throws BadSchemaException, TooBigDataException, NotEnoughDataException {
        if (in.readableBytes() < 48) {
            throw new NotEnoughDataException();
        }
        DefaultServerPushPacket packet = new DefaultServerPushPacket();
        ByteBuf fixHeaderBuf = in.retainedSlice(48);
        try {
            DefaultSPHead spHead = this.headFromByteBuf(fixHeaderBuf);
            packet.setSpHead(spHead);
            int bodyLength = spHead.bodyLength;
            if (bodyLength > 0x20000000) {
                throw new TooBigDataException("to big body size:" + bodyLength);
            }
            if (in.readableBytes() < 48 + bodyLength) {
                throw new NotEnoughDataException();
            }
            in.skipBytes(48);
            ByteBuf bodyBuf = in.readRetainedSlice(bodyLength);
            packet.setBodyBuf(bodyBuf);
            DefaultServerPushPacket defaultServerPushPacket = packet;
            return defaultServerPushPacket;
        }
        finally {
            fixHeaderBuf.release();
        }
    }

    public SPBody decodeBodyByteBuf(ByteBuf bodyByteBuf) {
        try {
            int readableBytes = bodyByteBuf.readableBytes();
            byte[] bodyBytes = new byte[readableBytes];
            bodyByteBuf.readBytes(bodyBytes);
            Schema schema = RuntimeSchema.getSchema(SPBody.class);
            SPBody spBody = new SPBody();
            ProtobufIOUtil.mergeFrom((byte[])bodyBytes, (Object)spBody, (Schema)schema);
            SPBody sPBody = spBody;
            return sPBody;
        }
        catch (Exception e) {
            throw new RpcException(e);
        }
        finally {
            if (bodyByteBuf != null) {
                bodyByteBuf.release();
            }
        }
    }

    @Override
    public Request createRequest() {
        return new RpcRequest();
    }

    @Override
    public Response createResponse() {
        return new RpcResponse();
    }

    @Override
    public Request getRequest() {
        RpcRequest request = RpcRequest.getRpcRequest();
        request.reset();
        return request;
    }

    @Override
    public Response getResponse() {
        RpcResponse response = RpcResponse.getRpcResponse();
        response.reset();
        return response;
    }

    @Override
    public boolean isCoexistence() {
        return true;
    }

    public ByteBuf encodeRequestBody(Request request, RpcMethodInfo rpcMethodInfo) {
        Validate.notNull((Object)request, (String)"body must not be empty", (Object[])new Object[0]);
        SPBody spBody = new SPBody();
        spBody.setServiceName(request.getServiceName());
        spBody.setMethodName(request.getMethodName());
        spBody.setParameters(request.getArgs());
        Schema schema = RuntimeSchema.getSchema(SPBody.class);
        byte[] bytes = ProtobufIOUtil.toByteArray((Object)spBody, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate((int)500));
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    public ByteBuf encodeResponseBody(Object result, RpcMethodInfo rpcMethodInfo) {
        Validate.notNull((Object)result, (String)"body must not be empty", (Object[])new Object[0]);
        SPBody spBody = new SPBody();
        spBody.setServiceName(rpcMethodInfo.getServiceName());
        spBody.setMethodName(rpcMethodInfo.getMethodName());
        spBody.setContent(result);
        Schema schema = RuntimeSchema.getSchema(SPBody.class);
        byte[] bytes = ProtobufIOUtil.toByteArray((Object)spBody, (Schema)schema, (LinkedBuffer)LinkedBuffer.allocate((int)500));
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    public void decodeRequestBody(SPBody body, Request request) {
        String serviceName = body.getServiceName();
        String methodName = body.getMethodName();
        RpcMethodInfo rpcMethodInfo = ServiceManager.getInstance().getService(serviceName, methodName);
        Validate.notNull((Object)rpcMethodInfo, (String)("find no method provider for service:" + serviceName + " , method:" + methodName), (Object[])new Object[0]);
        request.setArgs(body.getParameters());
        request.setServiceName(body.getServiceName());
        request.setMethodName(methodName);
        request.setRpcMethodInfo(rpcMethodInfo);
        request.setTarget(rpcMethodInfo.getTarget());
        request.setTargetMethod(rpcMethodInfo.getMethod());
    }

    @Override
    public SPHead createSPHead() {
        return new DefaultSPHead();
    }

    @Override
    public DefaultSPHead headFromByteBuf(ByteBuf buf) throws BadSchemaException {
        int n;
        DefaultSPHead head = new DefaultSPHead();
        if (buf.readableBytes() < 48) {
            throw new IllegalArgumentException("not enough bytes to read");
        }
        head.id = buf.readShortLE();
        head.version = buf.readShortLE();
        head.logId = buf.readLongLE();
        head.correlationId = buf.readLongLE();
        byte[] bytes = new byte[16];
        buf.readBytes(bytes);
        for (n = 0; n < bytes.length && bytes[n] != 0; ++n) {
        }
        head.provider = new String(bytes, 0, n);
        head.magicNumber = buf.readIntLE();
        if (head.magicNumber != -81782522) {
            throw new BadSchemaException("nshead magic number does not match");
        }
        head.type = buf.readIntLE();
        head.bodyLength = buf.readIntLE();
        return head;
    }

    @Override
    public ByteBuf headToBytes(SPHead spHead) {
        DefaultSPHead usedSpHead = (DefaultSPHead)spHead;
        ByteBuf buffer = Unpooled.buffer((int)48);
        buffer.writeShortLE((int)usedSpHead.id);
        buffer.writeShortLE((int)usedSpHead.version);
        buffer.writeLongLE(usedSpHead.logId);
        buffer.writeLongLE(usedSpHead.correlationId);
        byte[] providerBytes = usedSpHead.provider.getBytes();
        if (providerBytes.length >= 16) {
            buffer.writeBytes(providerBytes, 0, 16);
        } else {
            buffer.writeBytes(providerBytes, 0, providerBytes.length);
            buffer.writeBytes(DefaultSPHead.ZEROS, 0, 16 - providerBytes.length);
        }
        buffer.writeIntLE(usedSpHead.magicNumber);
        buffer.writeIntLE(usedSpHead.type);
        buffer.writeIntLE(usedSpHead.bodyLength);
        return buffer;
    }
}

