/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.JprotobufRpcMethodInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcContext;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.nshead.NSHead;
import com.baidu.brpc.protocol.nshead.NSHeadMeta;
import com.baidu.brpc.protocol.push.SPHead;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.utils.ProtobufUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrpcProxy
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrpcProxy.class);
    private static final Set<String> notProxyMethodSet = new HashSet<String>();
    private RpcClient rpcClient;
    private Map<String, RpcMethodInfo> rpcMethodMap = new HashMap<String, RpcMethodInfo>();

    protected BrpcProxy(RpcClient rpcClient, Class clazz) {
        Method[] methods;
        this.rpcClient = rpcClient;
        for (Method method : methods = clazz.getMethods()) {
            ProtobufUtils.MessageType messageType;
            if (notProxyMethodSet.contains(method.getName())) {
                log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
                continue;
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            int paramLength = parameterTypes.length;
            if (paramLength >= 1 && Future.class.isAssignableFrom(method.getReturnType()) && !RpcCallback.class.isAssignableFrom(parameterTypes[paramLength - 1])) {
                throw new IllegalArgumentException("returnType is Future, but last argument is not RpcCallback");
            }
            Method syncMethod = method;
            if (paramLength > 1) {
                int startIndex = 0;
                int endIndex = paramLength - 1;
                if (RpcCallback.class.isAssignableFrom(parameterTypes[paramLength - 1])) {
                    --endIndex;
                    --paramLength;
                }
                Class[] actualParameterTypes = new Class[paramLength];
                int i = 0;
                while (startIndex <= endIndex) {
                    actualParameterTypes[i] = parameterTypes[startIndex++];
                    ++i;
                }
                try {
                    syncMethod = method.getDeclaringClass().getMethod(method.getName(), actualParameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalArgumentException("can not find sync method:" + method.getName());
                }
            }
            Object methodInfo = (messageType = ProtobufUtils.getMessageType((Method)syncMethod)) == ProtobufUtils.MessageType.PROTOBUF ? new ProtobufRpcMethodInfo(syncMethod) : (messageType == ProtobufUtils.MessageType.JPROTOBUF ? new JprotobufRpcMethodInfo(syncMethod) : new RpcMethodInfo(syncMethod));
            this.rpcMethodMap.put(method.getName(), (RpcMethodInfo)methodInfo);
            log.debug("client serviceName={}, methodName={}", (Object)method.getDeclaringClass().getName(), (Object)method.getName());
        }
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz) {
        return BrpcProxy.getProxy(rpcClient, clazz, null);
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz, NamingOptions namingOptions) {
        rpcClient.setServiceInterface(clazz, namingOptions);
        Enhancer en = new Enhancer();
        en.setSuperclass(clazz);
        en.setCallback((Callback)new BrpcProxy(rpcClient, clazz));
        return (T)en.create();
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String methodName = method.getName();
        RpcMethodInfo rpcMethodInfo = this.rpcMethodMap.get(methodName);
        if (rpcMethodInfo == null) {
            log.debug("{}:{} does not need to proxy", (Object)method.getDeclaringClass().getName(), (Object)methodName);
            return proxy.invokeSuper(obj, args);
        }
        Request request = null;
        int readTimeout = 10000;
        int writeTimeout = 10000;
        Protocol protocol = this.rpcClient.getCommunicationOptions().getProtocol();
        request = protocol.createRequest();
        if (protocol instanceof ServerPushProtocol) {
            SPHead spHead = ((ServerPushProtocol)protocol).createSPHead();
            spHead.setType(0);
            request.setSpHead(spHead);
        }
        request.setCompressType(this.rpcClient.getRpcClientOptions().getCompressType().getNumber());
        request.setSubscribeInfo(this.rpcClient.getNamingServiceProcessor().getSubscribeInfo());
        readTimeout = this.rpcClient.getRpcClientOptions().getReadTimeoutMillis();
        writeTimeout = this.rpcClient.getRpcClientOptions().getWriteTimeoutMillis();
        try {
            Response response;
            block24: {
                request.setTarget(obj);
                request.setRpcMethodInfo(rpcMethodInfo);
                request.setTargetMethod(rpcMethodInfo.getMethod());
                request.setServiceName(rpcMethodInfo.getServiceName());
                request.setMethodName(rpcMethodInfo.getMethodName());
                NSHeadMeta nsHeadMeta = rpcMethodInfo.getNsHeadMeta();
                NSHead nsHead = nsHeadMeta == null ? new NSHead() : new NSHead(0, nsHeadMeta.id(), nsHeadMeta.version(), nsHeadMeta.provider(), 0);
                request.setNsHead(nsHead);
                RpcCallback callback = null;
                int argLength = args.length;
                if (argLength > 1) {
                    int startIndex = 0;
                    int endIndex = argLength - 1;
                    if (args[endIndex] instanceof RpcCallback) {
                        callback = (RpcCallback)args[endIndex];
                        --endIndex;
                        --argLength;
                    }
                    if (argLength <= 0) {
                        throw new RpcException(0, "invalid params");
                    }
                    Object[] sendArgs = new Object[argLength];
                    int i = 0;
                    while (startIndex <= endIndex) {
                        sendArgs[i] = args[startIndex++];
                        ++i;
                    }
                    request.setArgs(sendArgs);
                    request.setCallback(callback);
                } else {
                    request.setArgs(args);
                }
                if (RpcContext.isSet()) {
                    RpcContext rpcContext = RpcContext.getContext();
                    if (rpcContext.getRequestKvAttachment() != null) {
                        request.setKvAttachment(rpcContext.getRequestKvAttachment());
                    }
                    if (rpcContext.getRequestBinaryAttachment() != null) {
                        request.setBinaryAttachment(rpcContext.getRequestBinaryAttachment());
                    }
                    if (rpcContext.getLogId() != null) {
                        request.getNsHead().logId = rpcContext.getLogId().intValue();
                        request.setLogId(rpcContext.getLogId().longValue());
                    }
                    if (rpcContext.getServiceTag() != null) {
                        request.setServiceTag(rpcContext.getServiceTag());
                    }
                    if (rpcContext.getReadTimeoutMillis() != null) {
                        request.setReadTimeoutMillis(rpcContext.getReadTimeoutMillis());
                    }
                    if (rpcContext.getWriteTimeoutMillis() != null) {
                        request.setWriteTimeoutMillis(rpcContext.getWriteTimeoutMillis());
                    }
                    rpcContext.reset();
                }
                if (request.getReadTimeoutMillis() == null) {
                    request.setReadTimeoutMillis(Integer.valueOf(readTimeout));
                }
                if (request.getWriteTimeoutMillis() == null) {
                    request.setWriteTimeoutMillis(Integer.valueOf(writeTimeout));
                }
                try {
                    response = this.executeWithRetry(request);
                    if (request.getCallback() == null) break block24;
                    RpcFuture rpcFuture = response.getRpcFuture();
                    return rpcFuture;
                }
                catch (RpcException ex) {
                    log.error("exception :", (Throwable)ex);
                    throw ex;
                }
            }
            Object object = response.getResult();
            return object;
        }
        finally {
            if (request != null) {
                request.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeWithRetry(Request request) {
        Response response = null;
        RpcException exception = null;
        int currentTryTimes = 0;
        int maxTryTimes = this.rpcClient.getRpcClientOptions().getMaxTryTimes();
        while (currentTryTimes < maxTryTimes) {
            try {
                if (currentTryTimes > 0 && request.getChannel() != null) {
                    if (request.getSelectedInstances() == null) {
                        request.setSelectedInstances(new HashSet(maxTryTimes - 1));
                    }
                    request.getSelectedInstances().add(request.getCommunicationClient());
                }
                response = this.rpcClient.execute(request, this.rpcClient.getCommunicationOptions());
                break;
            }
            catch (RpcException ex) {
                exception = ex;
                if (exception.getCode() != 6) continue;
                break;
            }
            finally {
                ++currentTryTimes;
            }
        }
        if (response == null || response.getResult() == null && response.getRpcFuture() == null) {
            if (exception == null) {
                exception = new RpcException(0, "unknown error");
            }
            throw exception;
        }
        return response;
    }

    public Map<String, RpcMethodInfo> getRpcMethodMap() {
        return this.rpcMethodMap;
    }

    static {
        notProxyMethodSet.add("getClass");
        notProxyMethodSet.add("hashCode");
        notProxyMethodSet.add("equals");
        notProxyMethodSet.add("clone");
        notProxyMethodSet.add("toString");
        notProxyMethodSet.add("notify");
        notProxyMethodSet.add("notifyAll");
        notProxyMethodSet.add("wait");
        notProxyMethodSet.add("finalize");
    }
}

