/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.naming;

import com.baidu.brpc.naming.DnsNamingServiceFactory;
import com.baidu.brpc.naming.FileNamingServiceFactory;
import com.baidu.brpc.naming.ListNamingServiceFactory;
import com.baidu.brpc.naming.NamingServiceFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingServiceFactoryManager {
    private static final Logger log = LoggerFactory.getLogger(NamingServiceFactoryManager.class);
    private static volatile NamingServiceFactoryManager instance;
    private Map<String, NamingServiceFactory> namingServiceFactoryMap = new HashMap<String, NamingServiceFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamingServiceFactoryManager getInstance() {
        if (instance != null) return instance;
        Class<NamingServiceFactoryManager> clazz = NamingServiceFactoryManager.class;
        synchronized (NamingServiceFactoryManager.class) {
            if (instance != null) return instance;
            instance = new NamingServiceFactoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NamingServiceFactoryManager() {
        this.namingServiceFactoryMap.put("list", new ListNamingServiceFactory());
        this.namingServiceFactoryMap.put("file", new FileNamingServiceFactory());
        this.namingServiceFactoryMap.put("dns", new DnsNamingServiceFactory());
    }

    public void registerNamingServiceFactory(NamingServiceFactory namingServiceFactory) {
        if (this.namingServiceFactoryMap.get(namingServiceFactory.getName()) != null) {
            throw new RuntimeException("naming service exist:" + namingServiceFactory.getName());
        }
        this.namingServiceFactoryMap.put(namingServiceFactory.getName(), namingServiceFactory);
        log.info("register naming service:{} success", (Object)namingServiceFactory.getName());
    }

    public NamingServiceFactory getNamingServiceFactory(String name) {
        return this.namingServiceFactoryMap.get(name);
    }
}

