/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.spring.boot.autoconfigure.config;

import com.baidu.brpc.spring.boot.autoconfigure.config.BrpcConfig;
import com.baidu.brpc.spring.boot.autoconfigure.config.RpcClientConfig;
import com.baidu.brpc.spring.boot.autoconfigure.config.RpcNamingConfig;
import com.baidu.brpc.spring.boot.autoconfigure.config.RpcServerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="brpc")
public class BrpcProperties
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrpcProperties.class);
    private static final Pattern PATTERN_NOT_ALLOWED = Pattern.compile("[^a-zA-Z0-9\\-.]");
    @NestedConfigurationProperty
    private BrpcConfig global;
    private Environment environment;

    private static String camelToKebabCase(String str) {
        return str.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase();
    }

    private static String normalizeName(String original) {
        String normalized = BrpcProperties.camelToKebabCase(original);
        if (PATTERN_NOT_ALLOWED.matcher(normalized).find()) {
            normalized = normalized.replaceAll("[^a-zA-Z0-9\\-.]", "");
            LOGGER.warn("Service name '{}' contains characters which are not allowed in Spring Boot 2.0 canonical properties, therefore a normalized form  will be used for config value binding. Please use '{}' as the config key for your service custom configuration.", (Object)original, (Object)normalized);
        }
        return normalized;
    }

    private static void rewriteMap(Map<String, String> map) {
        if (map == null) {
            return;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < map.size() / 2; ++i) {
            String key = map.remove(i + ".key");
            String value = map.remove(i + ".value");
            if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) break;
            ret.put(key, value);
        }
        map.clear();
        map.putAll(ret);
    }

    public BrpcConfig getServiceConfig(Class<?> serviceInterface) {
        BrpcConfig brpcConfig = new BrpcConfig(this.global);
        if (brpcConfig.getClient() == null) {
            brpcConfig.setClient(new RpcClientConfig());
        }
        if (brpcConfig.getServer() == null) {
            brpcConfig.setServer(new RpcServerConfig());
        }
        if (brpcConfig.getNaming() == null) {
            brpcConfig.setNaming(new RpcNamingConfig());
        }
        String prefix = "brpc.custom." + BrpcProperties.normalizeName(serviceInterface.getName()) + ".";
        Binder binder = Binder.get((Environment)this.environment);
        binder.bind(prefix + "client", Bindable.ofInstance((Object)((Object)brpcConfig.getClient())));
        binder.bind(prefix + "server", Bindable.ofInstance((Object)((Object)brpcConfig.getServer())));
        binder.bind(prefix + "naming", Bindable.ofInstance((Object)((Object)brpcConfig.getNaming())));
        BrpcProperties.rewriteMap(brpcConfig.getNaming().getExtra());
        return brpcConfig;
    }

    public BrpcConfig getGlobal() {
        return this.global;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setGlobal(BrpcConfig global) {
        this.global = global;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

