/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.channel;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHttpClientConfig;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.CombinedConnectionSemaphore;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ConnectionSemaphore;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ConnectionSemaphoreFactory;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.MaxConnectionSemaphore;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.NoopConnectionSemaphore;

public class DefaultConnectionSemaphoreFactory
implements ConnectionSemaphoreFactory {
    @Override
    public ConnectionSemaphore newConnectionSemaphore(AsyncHttpClientConfig config) {
        int acquireFreeChannelTimeout = Math.max(0, config.getAcquireFreeChannelTimeout());
        int maxConnections = config.getMaxConnections();
        int maxConnectionsPerHost = config.getMaxConnectionsPerHost();
        if (maxConnections > 0 && maxConnectionsPerHost > 0) {
            return new CombinedConnectionSemaphore(maxConnections, maxConnectionsPerHost, acquireFreeChannelTimeout);
        }
        if (maxConnections > 0) {
            return new MaxConnectionSemaphore(maxConnections, acquireFreeChannelTimeout);
        }
        if (maxConnectionsPerHost > 0) {
            return new CombinedConnectionSemaphore(maxConnections, maxConnectionsPerHost, acquireFreeChannelTimeout);
        }
        return new NoopConnectionSemaphore();
    }
}

