/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.handler.intercept;

import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelManager;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.request.NettyRequestSender;
import com.baidu.cloud.thirdparty.asynchttpclient.proxy.ProxyServer;
import com.baidu.cloud.thirdparty.asynchttpclient.uri.Uri;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import com.baidu.cloud.thirdparty.netty.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSuccessInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectSuccessInterceptor.class);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;

    ConnectSuccessInterceptor(ChannelManager channelManager, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.requestSender = requestSender;
    }

    public boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer) {
        if (future.isKeepAlive()) {
            future.attachChannel(channel, true);
        }
        Uri requestUri = request.getUri();
        LOGGER.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)requestUri.getScheme());
        Future<Channel> whenHandshaked = this.channelManager.updatePipelineForHttpTunneling(channel.pipeline(), requestUri);
        future.setReuseChannel(true);
        future.setConnectAllowed(false);
        Request targetRequest = future.getTargetRequest().toBuilder().build();
        if (whenHandshaked == null) {
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, targetRequest);
        } else {
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, targetRequest, whenHandshaked);
        }
        return true;
    }
}

