/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.netty.request;

import com.baidu.cloud.thirdparty.asynchttpclient.handler.ProgressAsyncHandler;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.NettyResponseFuture;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.ChannelState;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.channel.Channels;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.future.StackTraceInspector;
import com.baidu.cloud.thirdparty.netty.channel.Channel;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteListener.class);
    protected final NettyResponseFuture<?> future;
    final ProgressAsyncHandler<?> progressAsyncHandler;
    final boolean notifyHeaders;

    WriteListener(NettyResponseFuture<?> future, boolean notifyHeaders) {
        this.future = future;
        this.progressAsyncHandler = future.getAsyncHandler() instanceof ProgressAsyncHandler ? (ProgressAsyncHandler)future.getAsyncHandler() : null;
        this.notifyHeaders = notifyHeaders;
    }

    private void abortOnThrowable(Channel channel, Throwable cause) {
        if (this.future.getChannelState() == ChannelState.POOLED && (cause instanceof IllegalStateException || cause instanceof ClosedChannelException || cause instanceof SSLException || StackTraceInspector.recoverOnReadOrWriteException(cause))) {
            LOGGER.debug("Write exception on pooled channel, letting retry trigger", cause);
        } else {
            this.future.abort(cause);
        }
        Channels.silentlyCloseChannel(channel);
    }

    void operationComplete(Channel channel, Throwable cause) {
        this.future.touch();
        if (cause != null) {
            this.abortOnThrowable(channel, cause);
            return;
        }
        if (this.progressAsyncHandler != null) {
            boolean startPublishing;
            boolean bl = startPublishing = !this.future.isInAuth() && !this.future.isInProxyAuth();
            if (startPublishing) {
                if (this.notifyHeaders) {
                    this.progressAsyncHandler.onHeadersWritten();
                } else {
                    this.progressAsyncHandler.onContentWritten();
                }
            }
        }
    }
}

