/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.oauth;

import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.RequestBuilderBase;
import com.baidu.cloud.thirdparty.asynchttpclient.SignatureCalculator;
import com.baidu.cloud.thirdparty.asynchttpclient.oauth.ConsumerKey;
import com.baidu.cloud.thirdparty.asynchttpclient.oauth.OAuthSignatureCalculatorInstance;
import com.baidu.cloud.thirdparty.asynchttpclient.oauth.RequestToken;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    private static final ThreadLocal<OAuthSignatureCalculatorInstance> INSTANCES = ThreadLocal.withInitial(() -> {
        try {
            return new OAuthSignatureCalculatorInstance();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    });
    private final ConsumerKey consumerAuth;
    private final RequestToken userAuth;

    public OAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth) {
        this.consumerAuth = consumerAuth;
        this.userAuth = userAuth;
    }

    @Override
    public void calculateAndAddSignature(Request request, RequestBuilderBase<?> requestBuilder) {
        try {
            String authorization = INSTANCES.get().computeAuthorizationHeader(this.consumerAuth, this.userAuth, request.getUri(), request.getMethod(), request.getFormParams(), request.getQueryParams());
            requestBuilder.setHeader((CharSequence)HttpHeaderNames.AUTHORIZATION, authorization);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Failed to compute a valid key from consumer and user secrets", e);
        }
    }
}

