/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.request.body.generator;

import com.baidu.cloud.thirdparty.asynchttpclient.request.body.Body;
import com.baidu.cloud.thirdparty.asynchttpclient.request.body.generator.BodyGenerator;
import com.baidu.cloud.thirdparty.netty.buffer.ByteBuf;

public final class ByteArrayBodyGenerator
implements BodyGenerator {
    private final byte[] bytes;

    public ByteArrayBodyGenerator(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public Body createBody() {
        return new ByteBody();
    }

    protected final class ByteBody
    implements Body {
        private boolean eof = false;
        private int lastPosition = 0;

        protected ByteBody() {
        }

        @Override
        public long getContentLength() {
            return ByteArrayBodyGenerator.this.bytes.length;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) {
            int initialTargetWritableBytes;
            if (this.eof) {
                return Body.BodyState.STOP;
            }
            int remaining = ByteArrayBodyGenerator.this.bytes.length - this.lastPosition;
            if (remaining <= (initialTargetWritableBytes = target.writableBytes())) {
                target.writeBytes(ByteArrayBodyGenerator.this.bytes, this.lastPosition, remaining);
                this.eof = true;
            } else {
                target.writeBytes(ByteArrayBodyGenerator.this.bytes, this.lastPosition, initialTargetWritableBytes);
                this.lastPosition += initialTargetWritableBytes;
            }
            return Body.BodyState.CONTINUE;
        }

        @Override
        public void close() {
            this.lastPosition = 0;
            this.eof = false;
        }
    }
}

