/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.resolver;

import com.baidu.cloud.thirdparty.asynchttpclient.AsyncHandler;
import com.baidu.cloud.thirdparty.asynchttpclient.netty.SimpleFutureListener;
import com.baidu.cloud.thirdparty.netty.resolver.NameResolver;
import com.baidu.cloud.thirdparty.netty.util.concurrent.Future;
import com.baidu.cloud.thirdparty.netty.util.concurrent.GenericFutureListener;
import com.baidu.cloud.thirdparty.netty.util.concurrent.ImmediateEventExecutor;
import com.baidu.cloud.thirdparty.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RequestHostnameResolver {
    INSTANCE;

    private static final Logger LOGGER;

    public Future<List<InetSocketAddress>> resolve(NameResolver<InetAddress> nameResolver, InetSocketAddress unresolvedAddress, final AsyncHandler<?> asyncHandler) {
        final String hostname = unresolvedAddress.getHostString();
        final int port = unresolvedAddress.getPort();
        final Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        try {
            asyncHandler.onHostnameResolutionAttempt(hostname);
        }
        catch (Exception e) {
            LOGGER.error("onHostnameResolutionAttempt crashed", (Throwable)e);
            promise.tryFailure(e);
            return promise;
        }
        Future<List<InetAddress>> whenResolved = nameResolver.resolveAll(hostname);
        whenResolved.addListener((GenericFutureListener<Future<List<InetAddress>>>)new SimpleFutureListener<List<InetAddress>>(){

            @Override
            protected void onSuccess(List<InetAddress> value) {
                ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(value.size());
                for (InetAddress a : value) {
                    socketAddresses.add(new InetSocketAddress(a, port));
                }
                try {
                    asyncHandler.onHostnameResolutionSuccess(hostname, socketAddresses);
                }
                catch (Exception e) {
                    LOGGER.error("onHostnameResolutionSuccess crashed", (Throwable)e);
                    promise.tryFailure(e);
                    return;
                }
                promise.trySuccess(socketAddresses);
            }

            @Override
            protected void onFailure(Throwable t) {
                try {
                    asyncHandler.onHostnameResolutionFailure(hostname, t);
                }
                catch (Exception e) {
                    LOGGER.error("onHostnameResolutionFailure crashed", (Throwable)e);
                    promise.tryFailure(e);
                    return;
                }
                promise.tryFailure(t);
            }
        });
        return promise;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RequestHostnameResolver.class);
    }
}

