/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.asynchttpclient.util;

import com.baidu.cloud.thirdparty.asynchttpclient.Dsl;
import com.baidu.cloud.thirdparty.asynchttpclient.Realm;
import com.baidu.cloud.thirdparty.asynchttpclient.Request;
import com.baidu.cloud.thirdparty.asynchttpclient.ntlm.NtlmEngine;
import com.baidu.cloud.thirdparty.asynchttpclient.proxy.ProxyServer;
import com.baidu.cloud.thirdparty.asynchttpclient.spnego.SpnegoEngine;
import com.baidu.cloud.thirdparty.asynchttpclient.spnego.SpnegoEngineException;
import com.baidu.cloud.thirdparty.asynchttpclient.uri.Uri;
import com.baidu.cloud.thirdparty.asynchttpclient.util.MiscUtils;
import com.baidu.cloud.thirdparty.asynchttpclient.util.StringUtils;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpHeaderNames;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;

public final class AuthenticatorUtils {
    public static final String NEGOTIATE = "Negotiate";

    public static String getHeaderWithPrefix(List<String> authenticateHeaders, String prefix) {
        if (authenticateHeaders != null) {
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                return authenticateHeader;
            }
        }
        return null;
    }

    private static String computeBasicAuthentication(Realm realm) {
        return realm != null ? AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset()) : null;
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(s.getBytes(charset));
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = uri.getNonEmptyPath();
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    private static String computeDigestAuthentication(Realm realm) {
        String realmUri = AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", realmUri, true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static void append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        builder.append(", ");
    }

    public static String perConnectionProxyAuthorizationHeader(Request request, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    List<String> auth = request.getHeaders().getAll(HttpHeaderNames.PROXY_AUTHORIZATION);
                    if (AuthenticatorUtils.getHeaderWithPrefix(auth, "NTLM") != null) break;
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    proxyAuthorization = "NTLM " + msg;
                    break;
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perRequestProxyAuthorizationHeader(Request request, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyRealm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(proxyRealm.getNonce())) break;
                    proxyRealm = Dsl.realm(proxyRealm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(proxyRealm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)proxyRealm.getScheme()));
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perConnectionAuthorizationHeader(Request request, ProxyServer proxyServer, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : request.getUri().getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.instance(realm.getPrincipal(), realm.getPassword(), realm.getServicePrincipalName(), realm.getRealmName(), realm.isUseCanonicalHostname(), realm.getCustomLoginConfig(), realm.getLoginContextName()).generateToken(host);
                        break;
                    }
                    catch (SpnegoEngineException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return authorizationHeader;
    }

    public static String perRequestAuthorizationHeader(Request request, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    realm = Dsl.realm(realm).setUri(request.getUri()).setMethodName(request.getMethod()).build();
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }
}

