/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.protostuff;

import com.baidu.cloud.thirdparty.protostuff.B64Code;
import com.baidu.cloud.thirdparty.protostuff.IntSerializer;
import com.baidu.cloud.thirdparty.protostuff.LinkedBuffer;
import com.baidu.cloud.thirdparty.protostuff.StreamedStringSerializer;
import com.baidu.cloud.thirdparty.protostuff.StringSerializer;
import com.baidu.cloud.thirdparty.protostuff.WriteSession;
import java.io.IOException;

public enum WriteSink {
    BUFFERED{

        @Override
        public LinkedBuffer drain(WriteSession session, LinkedBuffer lb) throws IOException {
            return new LinkedBuffer(session.nextBufferSize, lb);
        }

        @Override
        public LinkedBuffer writeByteArrayB64(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            return B64Code.encode(value, offset, valueLen, session, lb);
        }

        @Override
        public LinkedBuffer writeByteArray(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            if (valueLen == 0) {
                return lb;
            }
            session.size += valueLen;
            int available = lb.buffer.length - lb.offset;
            if (valueLen > available) {
                if (available + session.nextBufferSize < valueLen) {
                    if (available == 0) {
                        return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(value, offset, offset + valueLen, lb));
                    }
                    return new LinkedBuffer(lb, new LinkedBuffer(value, offset, offset + valueLen, lb));
                }
                System.arraycopy(value, offset, lb.buffer, lb.offset, available);
                lb.offset += available;
                lb = new LinkedBuffer(session.nextBufferSize, lb);
                int leftover = valueLen - available;
                System.arraycopy(value, offset + available, lb.buffer, 0, leftover);
                lb.offset += leftover;
                return lb;
            }
            System.arraycopy(value, offset, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            return lb;
        }

        @Override
        public LinkedBuffer writeByte(byte value, WriteSession session, LinkedBuffer lb) throws IOException {
            ++session.size;
            if (lb.offset == lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            lb.buffer[lb.offset++] = value;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt16(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 2;
            if (lb.offset + 2 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt16(value, lb.buffer, lb.offset);
            lb.offset += 2;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt16LE(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 2;
            if (lb.offset + 2 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt16LE(value, lb.buffer, lb.offset);
            lb.offset += 2;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt32(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt64(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt32LE(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt32LE(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt64LE(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                lb = new LinkedBuffer(session.nextBufferSize, lb);
            }
            IntSerializer.writeInt64LE(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        @Override
        public LinkedBuffer writeVarInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    lb = new LinkedBuffer(session.nextBufferSize, lb);
                }
                if ((value & 0xFFFFFF80) == 0) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        @Override
        public LinkedBuffer writeVarInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    lb = new LinkedBuffer(session.nextBufferSize, lb);
                }
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        @Override
        public LinkedBuffer writeStrFromInt(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeInt(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrFromLong(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeLong(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrFromFloat(float value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeFloat(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrFromDouble(double value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeDouble(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrAscii(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeAscii(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrUTF8(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeUTF8(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrUTF8VarDelimited(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeUTF8VarDelimited(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrUTF8FixedDelimited(CharSequence value, boolean littleEndian, WriteSession session, LinkedBuffer lb) throws IOException {
            return StringSerializer.writeUTF8FixedDelimited(value, littleEndian, session, lb);
        }
    }
    ,
    STREAMED{

        @Override
        public LinkedBuffer drain(WriteSession session, LinkedBuffer lb) throws IOException {
            lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            return lb;
        }

        @Override
        public LinkedBuffer writeByteArrayB64(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            return B64Code.sencode(value, offset, valueLen, session, lb);
        }

        @Override
        public LinkedBuffer writeByteArray(byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) throws IOException {
            if (valueLen == 0) {
                return lb;
            }
            session.size += valueLen;
            if (lb.offset + valueLen > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start, value, offset, valueLen);
                return lb;
            }
            System.arraycopy(value, offset, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            return lb;
        }

        @Override
        public LinkedBuffer writeByte(byte value, WriteSession session, LinkedBuffer lb) throws IOException {
            ++session.size;
            if (lb.offset == lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            lb.buffer[lb.offset++] = value;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt16(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 2;
            if (lb.offset + 2 > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            IntSerializer.writeInt16(value, lb.buffer, lb.offset);
            lb.offset += 2;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt16LE(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 2;
            if (lb.offset + 2 > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            IntSerializer.writeInt16LE(value, lb.buffer, lb.offset);
            lb.offset += 2;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            IntSerializer.writeInt32(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            IntSerializer.writeInt64(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt32LE(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 4;
            if (lb.offset + 4 > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            IntSerializer.writeInt32LE(value, lb.buffer, lb.offset);
            lb.offset += 4;
            return lb;
        }

        @Override
        public LinkedBuffer writeInt64LE(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            session.size += 8;
            if (lb.offset + 8 > lb.buffer.length) {
                lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
            }
            IntSerializer.writeInt64LE(value, lb.buffer, lb.offset);
            lb.offset += 8;
            return lb;
        }

        @Override
        public LinkedBuffer writeVarInt32(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
                }
                if ((value & 0xFFFFFF80) == 0) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)(value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        @Override
        public LinkedBuffer writeVarInt64(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            while (true) {
                ++session.size;
                if (lb.offset == lb.buffer.length) {
                    lb.offset = session.flush(lb.buffer, lb.start, lb.offset - lb.start);
                }
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    lb.buffer[lb.offset++] = (byte)value;
                    return lb;
                }
                lb.buffer[lb.offset++] = (byte)((int)value & 0x7F | 0x80);
                value >>>= 7;
            }
        }

        @Override
        public LinkedBuffer writeStrFromInt(int value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeInt(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrFromLong(long value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeLong(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrFromFloat(float value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeFloat(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrFromDouble(double value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeDouble(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrAscii(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeAscii(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrUTF8(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeUTF8(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrUTF8VarDelimited(CharSequence value, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeUTF8VarDelimited(value, session, lb);
        }

        @Override
        public LinkedBuffer writeStrUTF8FixedDelimited(CharSequence value, boolean littleEndian, WriteSession session, LinkedBuffer lb) throws IOException {
            return StreamedStringSerializer.writeUTF8FixedDelimited(value, littleEndian, session, lb);
        }
    };


    public abstract LinkedBuffer drain(WriteSession var1, LinkedBuffer var2) throws IOException;

    public final LinkedBuffer writeByteArrayB64(byte[] value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeByteArrayB64(value, 0, value.length, session, lb);
    }

    public abstract LinkedBuffer writeByteArrayB64(byte[] var1, int var2, int var3, WriteSession var4, LinkedBuffer var5) throws IOException;

    public final LinkedBuffer writeByteArray(byte[] value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeByteArray(value, 0, value.length, session, lb);
    }

    public abstract LinkedBuffer writeByteArray(byte[] var1, int var2, int var3, WriteSession var4, LinkedBuffer var5) throws IOException;

    public abstract LinkedBuffer writeByte(byte var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt32(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt64(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public final LinkedBuffer writeFloat(float value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt32(Float.floatToRawIntBits(value), session, lb);
    }

    public final LinkedBuffer writeDouble(double value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt64(Double.doubleToRawLongBits(value), session, lb);
    }

    public abstract LinkedBuffer writeInt16(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt16LE(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt32LE(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeInt64LE(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public final LinkedBuffer writeFloatLE(float value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt32LE(Float.floatToRawIntBits(value), session, lb);
    }

    public final LinkedBuffer writeDoubleLE(double value, WriteSession session, LinkedBuffer lb) throws IOException {
        return this.writeInt64LE(Double.doubleToRawLongBits(value), session, lb);
    }

    public abstract LinkedBuffer writeVarInt32(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeVarInt64(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public abstract LinkedBuffer writeStrFromInt(int var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrFromLong(long var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public abstract LinkedBuffer writeStrFromFloat(float var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrFromDouble(double var1, WriteSession var3, LinkedBuffer var4) throws IOException;

    public abstract LinkedBuffer writeStrAscii(CharSequence var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrUTF8(CharSequence var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrUTF8VarDelimited(CharSequence var1, WriteSession var2, LinkedBuffer var3) throws IOException;

    public abstract LinkedBuffer writeStrUTF8FixedDelimited(CharSequence var1, boolean var2, WriteSession var3, LinkedBuffer var4) throws IOException;
}

