/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.framework;

import com.baidu.cloud.thirdparty.springframework.aop.TargetSource;
import com.baidu.cloud.thirdparty.springframework.aop.framework.ProxyConfig;
import com.baidu.cloud.thirdparty.springframework.aop.framework.ProxyFactory;
import com.baidu.cloud.thirdparty.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import com.baidu.cloud.thirdparty.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import com.baidu.cloud.thirdparty.springframework.aop.target.SingletonTargetSource;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanClassLoaderAware;
import com.baidu.cloud.thirdparty.springframework.beans.factory.FactoryBean;
import com.baidu.cloud.thirdparty.springframework.beans.factory.FactoryBeanNotInitializedException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;

public abstract class AbstractSingletonProxyFactoryBean
extends ProxyConfig
implements FactoryBean<Object>,
BeanClassLoaderAware,
InitializingBean {
    @Nullable
    private Object target;
    @Nullable
    private Class<?>[] proxyInterfaces;
    @Nullable
    private Object[] preInterceptors;
    @Nullable
    private Object[] postInterceptors;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    @Nullable
    private transient ClassLoader proxyClassLoader;
    @Nullable
    private Object proxy;

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProxyInterfaces(Class<?>[] proxyInterfaces) {
        this.proxyInterfaces = proxyInterfaces;
    }

    public void setPreInterceptors(Object[] preInterceptors) {
        this.preInterceptors = preInterceptors;
    }

    public void setPostInterceptors(Object[] postInterceptors) {
        this.postInterceptors = postInterceptors;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setProxyClassLoader(ClassLoader classLoader) {
        this.proxyClassLoader = classLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        if (this.proxyClassLoader == null) {
            this.proxyClassLoader = classLoader;
        }
    }

    @Override
    public void afterPropertiesSet() {
        Class<?> targetClass;
        if (this.target == null) {
            throw new IllegalArgumentException("Property 'target' is required");
        }
        if (this.target instanceof String) {
            throw new IllegalArgumentException("'target' needs to be a bean reference, not a bean name as value");
        }
        if (this.proxyClassLoader == null) {
            this.proxyClassLoader = ClassUtils.getDefaultClassLoader();
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.preInterceptors != null) {
            for (Object interceptor : this.preInterceptors) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(interceptor));
            }
        }
        proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.createMainInterceptor()));
        if (this.postInterceptors != null) {
            for (Object interceptor : this.postInterceptors) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(interceptor));
            }
        }
        proxyFactory.copyFrom(this);
        TargetSource targetSource = this.createTargetSource(this.target);
        proxyFactory.setTargetSource(targetSource);
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!this.isProxyTargetClass() && (targetClass = targetSource.getTargetClass()) != null) {
            proxyFactory.setInterfaces(ClassUtils.getAllInterfacesForClass(targetClass, this.proxyClassLoader));
        }
        this.postProcessProxyFactory(proxyFactory);
        this.proxy = proxyFactory.getProxy(this.proxyClassLoader);
    }

    protected TargetSource createTargetSource(Object target) {
        if (target instanceof TargetSource) {
            return (TargetSource)target;
        }
        return new SingletonTargetSource(target);
    }

    protected void postProcessProxyFactory(ProxyFactory proxyFactory) {
    }

    @Override
    public Object getObject() {
        if (this.proxy == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.proxy;
    }

    @Override
    @Nullable
    public Class<?> getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.proxyInterfaces != null && this.proxyInterfaces.length == 1) {
            return this.proxyInterfaces[0];
        }
        if (this.target instanceof TargetSource) {
            return ((TargetSource)this.target).getTargetClass();
        }
        if (this.target != null) {
            return this.target.getClass();
        }
        return null;
    }

    @Override
    public final boolean isSingleton() {
        return true;
    }

    protected abstract Object createMainInterceptor();
}

