/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.support;

import com.baidu.cloud.thirdparty.springframework.aop.support.StaticMethodMatcherPointcut;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.PatternMatchUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NameMatchMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private List<String> mappedNames = new ArrayList<String>();

    public void setMappedName(String mappedName) {
        this.setMappedNames(mappedName);
    }

    public void setMappedNames(String ... mappedNames) {
        this.mappedNames = new ArrayList<String>(Arrays.asList(mappedNames));
    }

    public NameMatchMethodPointcut addMethodName(String name) {
        this.mappedNames.add(name);
        return this;
    }

    @Override
    public boolean matches(Method method, @Nullable Class<?> targetClass) {
        for (String mappedName : this.mappedNames) {
            if (!mappedName.equals(method.getName()) && !this.isMatch(method.getName(), mappedName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NameMatchMethodPointcut && this.mappedNames.equals(((NameMatchMethodPointcut)other).mappedNames);
    }

    public int hashCode() {
        return this.mappedNames.hashCode();
    }
}

