/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.aop.support.annotation;

import com.baidu.cloud.thirdparty.springframework.aop.support.AopUtils;
import com.baidu.cloud.thirdparty.springframework.aop.support.StaticMethodMatcher;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AnnotationMethodMatcher
extends StaticMethodMatcher {
    private final Class<? extends Annotation> annotationType;
    private final boolean checkInherited;

    public AnnotationMethodMatcher(Class<? extends Annotation> annotationType) {
        this(annotationType, false);
    }

    public AnnotationMethodMatcher(Class<? extends Annotation> annotationType, boolean checkInherited) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        this.annotationType = annotationType;
        this.checkInherited = checkInherited;
    }

    @Override
    public boolean matches(Method method, @Nullable Class<?> targetClass) {
        if (this.matchesMethod(method)) {
            return true;
        }
        if (targetClass != null && Proxy.isProxyClass(targetClass)) {
            return false;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        return specificMethod != method && this.matchesMethod(specificMethod);
    }

    private boolean matchesMethod(Method method) {
        return this.checkInherited ? AnnotationUtils.findAnnotation(method, this.annotationType) != null : method.isAnnotationPresent(this.annotationType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationMethodMatcher)) {
            return false;
        }
        AnnotationMethodMatcher otherMm = (AnnotationMethodMatcher)other;
        return this.annotationType.equals(otherMm.annotationType);
    }

    public int hashCode() {
        return this.annotationType.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.annotationType;
    }
}

