/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.beans.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.BeanWrapper;
import com.baidu.cloud.thirdparty.springframework.beans.PropertyAccessorFactory;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.ReflectionUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringValueResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

public abstract class AnnotationBeanUtils {
    public static void copyPropertiesToBean(Annotation ann, Object bean2, String ... excludedProperties) {
        AnnotationBeanUtils.copyPropertiesToBean(ann, bean2, null, excludedProperties);
    }

    public static void copyPropertiesToBean(Annotation ann, Object bean2, @Nullable StringValueResolver valueResolver, String ... excludedProperties) {
        HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedProperties));
        Method[] annotationProperties = ann.annotationType().getDeclaredMethods();
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(bean2);
        for (Method annotationProperty : annotationProperties) {
            String propertyName = annotationProperty.getName();
            if (excluded.contains(propertyName) || !bw.isWritableProperty(propertyName)) continue;
            Object value = ReflectionUtils.invokeMethod(annotationProperty, ann);
            if (valueResolver != null && value instanceof String) {
                value = valueResolver.resolveStringValue((String)value);
            }
            bw.setPropertyValue(propertyName, value);
        }
    }
}

