/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.cache.interceptor;

import com.baidu.cloud.thirdparty.springframework.cache.Cache;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.CacheErrorHandler;
import com.baidu.cloud.thirdparty.springframework.cache.interceptor.SimpleCacheErrorHandler;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;

public abstract class AbstractCacheInvoker {
    private CacheErrorHandler errorHandler;

    protected AbstractCacheInvoker() {
        this.errorHandler = new SimpleCacheErrorHandler();
    }

    protected AbstractCacheInvoker(CacheErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setErrorHandler(CacheErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, "CacheErrorHandler must not be null");
        this.errorHandler = errorHandler;
    }

    public CacheErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Nullable
    protected Cache.ValueWrapper doGet(Cache cache, Object key) {
        try {
            return cache.get(key);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheGetError(ex, cache, key);
            return null;
        }
    }

    protected void doPut(Cache cache, Object key, @Nullable Object result) {
        try {
            cache.put(key, result);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCachePutError(ex, cache, key, result);
        }
    }

    protected void doEvict(Cache cache, Object key) {
        try {
            cache.evict(key);
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheEvictError(ex, cache, key);
        }
    }

    protected void doClear(Cache cache) {
        try {
            cache.clear();
        }
        catch (RuntimeException ex) {
            this.getErrorHandler().handleCacheClearError(ex, cache);
        }
    }
}

