/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.springframework.context.annotation.AdviceMode;
import com.baidu.cloud.thirdparty.springframework.context.annotation.AnnotationConfigUtils;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ImportSelector;
import com.baidu.cloud.thirdparty.springframework.core.GenericTypeResolver;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotatedTypeMetadata;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.lang.annotation.Annotation;

public abstract class AdviceModeImportSelector<A extends Annotation>
implements ImportSelector {
    public static final String DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME = "mode";

    protected String getAdviceModeAttributeName() {
        return DEFAULT_ADVICE_MODE_ATTRIBUTE_NAME;
    }

    @Override
    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Class<?> annType = GenericTypeResolver.resolveTypeArgument(this.getClass(), AdviceModeImportSelector.class);
        Assert.state(annType != null, "Unresolvable type argument for AdviceModeImportSelector");
        AnnotationAttributes attributes = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importingClassMetadata, annType);
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("@%s is not present on importing class '%s' as expected", annType.getSimpleName(), importingClassMetadata.getClassName()));
        }
        AdviceMode adviceMode = (AdviceMode)((Object)attributes.getEnum(this.getAdviceModeAttributeName()));
        String[] imports = this.selectImports(adviceMode);
        if (imports == null) {
            throw new IllegalArgumentException("Unknown AdviceMode: " + (Object)((Object)adviceMode));
        }
        return imports;
    }

    @Nullable
    protected abstract String[] selectImports(AdviceMode var1);
}

