/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.annotation;

import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactory;
import com.baidu.cloud.thirdparty.springframework.beans.factory.BeanFactoryAware;
import com.baidu.cloud.thirdparty.springframework.context.EnvironmentAware;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Bean;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Configuration;
import com.baidu.cloud.thirdparty.springframework.context.annotation.EnableMBeanExport;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ImportAware;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Role;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.env.Environment;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.jmx.MBeanServerNotFoundException;
import com.baidu.cloud.thirdparty.springframework.jmx.export.annotation.AnnotationMBeanExporter;
import com.baidu.cloud.thirdparty.springframework.jmx.support.RegistrationPolicy;
import com.baidu.cloud.thirdparty.springframework.jmx.support.WebSphereMBeanServerFactoryBean;
import com.baidu.cloud.thirdparty.springframework.jndi.JndiLocatorDelegate;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.util.Map;
import javax.management.MBeanServer;
import javax.naming.NamingException;

@Configuration
public class MBeanExportConfiguration
implements ImportAware,
EnvironmentAware,
BeanFactoryAware {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";
    @Nullable
    private AnnotationAttributes enableMBeanExport;
    @Nullable
    private Environment environment;
    @Nullable
    private BeanFactory beanFactory;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map<String, Object> map = importMetadata.getAnnotationAttributes(EnableMBeanExport.class.getName());
        this.enableMBeanExport = AnnotationAttributes.fromMap(map);
        if (this.enableMBeanExport == null) {
            throw new IllegalArgumentException("@EnableMBeanExport is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Bean(name={"mbeanExporter"})
    @Role(value=2)
    public AnnotationMBeanExporter mbeanExporter() {
        AnnotationMBeanExporter exporter = new AnnotationMBeanExporter();
        Assert.state(this.enableMBeanExport != null, "No EnableMBeanExport annotation found");
        this.setupDomain(exporter, this.enableMBeanExport);
        this.setupServer(exporter, this.enableMBeanExport);
        this.setupRegistrationPolicy(exporter, this.enableMBeanExport);
        return exporter;
    }

    private void setupDomain(AnnotationMBeanExporter exporter, AnnotationAttributes enableMBeanExport) {
        String defaultDomain = enableMBeanExport.getString("defaultDomain");
        if (StringUtils.hasLength(defaultDomain) && this.environment != null) {
            defaultDomain = this.environment.resolvePlaceholders(defaultDomain);
        }
        if (StringUtils.hasText(defaultDomain)) {
            exporter.setDefaultDomain(defaultDomain);
        }
    }

    private void setupServer(AnnotationMBeanExporter exporter, AnnotationAttributes enableMBeanExport) {
        String server = enableMBeanExport.getString("server");
        if (StringUtils.hasLength(server) && this.environment != null) {
            server = this.environment.resolvePlaceholders(server);
        }
        if (StringUtils.hasText(server)) {
            Assert.state(this.beanFactory != null, "No BeanFactory set");
            exporter.setServer(this.beanFactory.getBean(server, MBeanServer.class));
        } else {
            MBeanServer mbeanServer;
            SpecificPlatform specificPlatform = SpecificPlatform.get();
            if (specificPlatform != null && (mbeanServer = specificPlatform.getMBeanServer()) != null) {
                exporter.setServer(mbeanServer);
            }
        }
    }

    private void setupRegistrationPolicy(AnnotationMBeanExporter exporter, AnnotationAttributes enableMBeanExport) {
        RegistrationPolicy registrationPolicy = (RegistrationPolicy)((Object)enableMBeanExport.getEnum("registration"));
        exporter.setRegistrationPolicy(registrationPolicy);
    }

    public static enum SpecificPlatform {
        WEBLOGIC("weblogic.management.Helper"){

            @Override
            public MBeanServer getMBeanServer() {
                try {
                    return new JndiLocatorDelegate().lookup("java:comp/env/jmx/runtime", MBeanServer.class);
                }
                catch (NamingException ex) {
                    throw new MBeanServerNotFoundException("Failed to retrieve WebLogic MBeanServer from JNDI", ex);
                }
            }
        }
        ,
        WEBSPHERE("com.ibm.websphere.management.AdminServiceFactory"){

            @Override
            public MBeanServer getMBeanServer() {
                WebSphereMBeanServerFactoryBean fb = new WebSphereMBeanServerFactoryBean();
                fb.afterPropertiesSet();
                return fb.getObject();
            }
        };

        private final String identifyingClass;

        private SpecificPlatform(String identifyingClass) {
            this.identifyingClass = identifyingClass;
        }

        @Nullable
        public abstract MBeanServer getMBeanServer();

        @Nullable
        public static SpecificPlatform get() {
            ClassLoader classLoader = MBeanExportConfiguration.class.getClassLoader();
            for (SpecificPlatform environment2 : SpecificPlatform.values()) {
                if (!ClassUtils.isPresent(environment2.identifyingClass, classLoader)) continue;
                return environment2;
            }
            return null;
        }
    }
}

