/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.context.support;

import com.baidu.cloud.thirdparty.springframework.beans.BeansException;
import com.baidu.cloud.thirdparty.springframework.beans.factory.Aware;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.BeanPostProcessor;
import com.baidu.cloud.thirdparty.springframework.beans.factory.config.EmbeddedValueResolver;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationContextAware;
import com.baidu.cloud.thirdparty.springframework.context.ApplicationEventPublisherAware;
import com.baidu.cloud.thirdparty.springframework.context.ConfigurableApplicationContext;
import com.baidu.cloud.thirdparty.springframework.context.EmbeddedValueResolverAware;
import com.baidu.cloud.thirdparty.springframework.context.EnvironmentAware;
import com.baidu.cloud.thirdparty.springframework.context.MessageSourceAware;
import com.baidu.cloud.thirdparty.springframework.context.ResourceLoaderAware;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.StringValueResolver;
import java.security.AccessControlContext;
import java.security.AccessController;

class ApplicationContextAwareProcessor
implements BeanPostProcessor {
    private final ConfigurableApplicationContext applicationContext;
    private final StringValueResolver embeddedValueResolver;

    public ApplicationContextAwareProcessor(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.embeddedValueResolver = new EmbeddedValueResolver(applicationContext.getBeanFactory());
    }

    @Override
    @Nullable
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        AccessControlContext acc = null;
        if (System.getSecurityManager() != null && (bean2 instanceof EnvironmentAware || bean2 instanceof EmbeddedValueResolverAware || bean2 instanceof ResourceLoaderAware || bean2 instanceof ApplicationEventPublisherAware || bean2 instanceof MessageSourceAware || bean2 instanceof ApplicationContextAware)) {
            acc = this.applicationContext.getBeanFactory().getAccessControlContext();
        }
        if (acc != null) {
            AccessController.doPrivileged(() -> {
                this.invokeAwareInterfaces(bean2);
                return null;
            }, acc);
        } else {
            this.invokeAwareInterfaces(bean2);
        }
        return bean2;
    }

    private void invokeAwareInterfaces(Object bean2) {
        if (bean2 instanceof Aware) {
            if (bean2 instanceof EnvironmentAware) {
                ((EnvironmentAware)bean2).setEnvironment(this.applicationContext.getEnvironment());
            }
            if (bean2 instanceof EmbeddedValueResolverAware) {
                ((EmbeddedValueResolverAware)bean2).setEmbeddedValueResolver(this.embeddedValueResolver);
            }
            if (bean2 instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)bean2).setResourceLoader(this.applicationContext);
            }
            if (bean2 instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)bean2).setApplicationEventPublisher(this.applicationContext);
            }
            if (bean2 instanceof MessageSourceAware) {
                ((MessageSourceAware)bean2).setMessageSource(this.applicationContext);
            }
            if (bean2 instanceof ApplicationContextAware) {
                ((ApplicationContextAware)bean2).setApplicationContext(this.applicationContext);
            }
        }
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        return bean2;
    }
}

