/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.core.codec;

import com.baidu.cloud.thirdparty.reactivestreams.Publisher;
import com.baidu.cloud.thirdparty.springframework.core.ResolvableType;
import com.baidu.cloud.thirdparty.springframework.core.codec.AbstractDataBufferDecoder;
import com.baidu.cloud.thirdparty.springframework.core.io.ByteArrayResource;
import com.baidu.cloud.thirdparty.springframework.core.io.InputStreamResource;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.MimeType;
import com.baidu.cloud.thirdparty.springframework.util.MimeTypeUtils;
import java.io.ByteArrayInputStream;
import java.util.Map;
import reactor.core.publisher.Flux;

public class ResourceDecoder
extends AbstractDataBufferDecoder<Resource> {
    public ResourceDecoder() {
        super(MimeTypeUtils.ALL);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<?> clazz = elementType.getRawClass();
        return clazz != null && Resource.class.isAssignableFrom(clazz) && super.canDecode(elementType, mimeType);
    }

    @Override
    public Flux<Resource> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(this.decodeToMono(inputStream, elementType, mimeType, hints));
    }

    @Override
    protected Resource decodeDataBuffer(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release(dataBuffer);
        Class<?> clazz = elementType.getRawClass();
        Assert.state(clazz != null, "No resource class");
        if (InputStreamResource.class == clazz) {
            return new InputStreamResource(new ByteArrayInputStream(bytes));
        }
        if (Resource.class.isAssignableFrom(clazz)) {
            return new ByteArrayResource(bytes);
        }
        throw new IllegalStateException("Unsupported resource class: " + clazz);
    }
}

