/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.core.codec;

import com.baidu.cloud.thirdparty.springframework.core.ResolvableType;
import com.baidu.cloud.thirdparty.springframework.core.codec.AbstractSingleValueEncoder;
import com.baidu.cloud.thirdparty.springframework.core.io.Resource;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferUtils;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.MimeType;
import com.baidu.cloud.thirdparty.springframework.util.MimeTypeUtils;
import java.util.Map;
import reactor.core.publisher.Flux;

public class ResourceEncoder
extends AbstractSingleValueEncoder<Resource> {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final int bufferSize;

    public ResourceEncoder() {
        this(4096);
    }

    public ResourceEncoder(int bufferSize) {
        super(MimeTypeUtils.APPLICATION_OCTET_STREAM, MimeTypeUtils.ALL);
        Assert.isTrue(bufferSize > 0, "'bufferSize' must be larger than 0");
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class<?> clazz = elementType.resolve(Object.class);
        return super.canEncode(elementType, mimeType) && Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Flux<DataBuffer> encode(Resource resource, DataBufferFactory dataBufferFactory, ResolvableType type, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return DataBufferUtils.read(resource, dataBufferFactory, this.bufferSize);
    }
}

