/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.expression.spel.ast;

import com.baidu.cloud.thirdparty.springframework.asm.MethodVisitor;
import com.baidu.cloud.thirdparty.springframework.asm.Type;
import com.baidu.cloud.thirdparty.springframework.expression.EvaluationException;
import com.baidu.cloud.thirdparty.springframework.expression.TypedValue;
import com.baidu.cloud.thirdparty.springframework.expression.spel.CodeFlow;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ExpressionState;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelEvaluationException;
import com.baidu.cloud.thirdparty.springframework.expression.spel.SpelMessage;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ast.Operator;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ast.SpelNodeImpl;
import com.baidu.cloud.thirdparty.springframework.expression.spel.ast.TypeReference;
import com.baidu.cloud.thirdparty.springframework.expression.spel.support.BooleanTypedValue;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;

public class OperatorInstanceof
extends Operator {
    @Nullable
    private Class<?> type;

    public OperatorInstanceof(int pos, SpelNodeImpl ... operands) {
        super("instanceof", pos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl rightOperand = this.getRightOperand();
        TypedValue left = this.getLeftOperand().getValueInternal(state);
        TypedValue right = rightOperand.getValueInternal(state);
        Object leftValue = left.getValue();
        Object rightValue = right.getValue();
        if (rightValue == null || !(rightValue instanceof Class)) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.INSTANCEOF_OPERATOR_NEEDS_CLASS_OPERAND, rightValue == null ? "null" : rightValue.getClass().getName());
        }
        Class rightClass = (Class)rightValue;
        BooleanTypedValue result = leftValue == null ? BooleanTypedValue.FALSE : BooleanTypedValue.forValue(rightClass.isAssignableFrom(leftValue.getClass()));
        this.type = rightClass;
        if (rightOperand instanceof TypeReference) {
            this.exitTypeDescriptor = "Z";
        }
        return result;
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null && this.getLeftOperand().isCompilable();
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        this.getLeftOperand().generateCode(mv, cf);
        CodeFlow.insertBoxIfNecessary(mv, cf.lastDescriptor());
        Assert.state(this.type != null, "No type available");
        if (this.type.isPrimitive()) {
            mv.visitInsn(87);
            mv.visitInsn(3);
        } else {
            mv.visitTypeInsn(193, Type.getInternalName(this.type));
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

