/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.format.datetime;

import com.baidu.cloud.thirdparty.springframework.context.support.EmbeddedValueResolutionSupport;
import com.baidu.cloud.thirdparty.springframework.format.AnnotationFormatterFactory;
import com.baidu.cloud.thirdparty.springframework.format.Formatter;
import com.baidu.cloud.thirdparty.springframework.format.Parser;
import com.baidu.cloud.thirdparty.springframework.format.Printer;
import com.baidu.cloud.thirdparty.springframework.format.annotation.DateTimeFormat;
import com.baidu.cloud.thirdparty.springframework.format.datetime.DateFormatter;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DateTimeFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<DateTimeFormat> {
    private static final Set<Class<?>> FIELD_TYPES;

    @Override
    public Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    @Override
    public Printer<?> getPrinter(DateTimeFormat annotation, Class<?> fieldType) {
        return this.getFormatter(annotation, fieldType);
    }

    @Override
    public Parser<?> getParser(DateTimeFormat annotation, Class<?> fieldType) {
        return this.getFormatter(annotation, fieldType);
    }

    protected Formatter<Date> getFormatter(DateTimeFormat annotation, Class<?> fieldType) {
        DateFormatter formatter = new DateFormatter();
        String style = this.resolveEmbeddedValue(annotation.style());
        if (StringUtils.hasLength(style)) {
            formatter.setStylePattern(style);
        }
        formatter.setIso(annotation.iso());
        String pattern = this.resolveEmbeddedValue(annotation.pattern());
        if (StringUtils.hasLength(pattern)) {
            formatter.setPattern(pattern);
        }
        return formatter;
    }

    static {
        HashSet<Class<Long>> fieldTypes = new HashSet<Class<Long>>(4);
        fieldTypes.add(Date.class);
        fieldTypes.add(Calendar.class);
        fieldTypes.add(Long.class);
        FIELD_TYPES = Collections.unmodifiableSet(fieldTypes);
    }
}

