/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client.reactive;

import com.baidu.cloud.thirdparty.netty.buffer.UnpooledByteBufAllocator;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.NettyDataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ClientHttpConnector;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ClientHttpResponse;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ReactorClientHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.reactive.ReactorClientHttpResponse;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public class ReactorClientHttpConnector
implements ClientHttpConnector {
    static final NettyDataBufferFactory BUFFER_FACTORY = new NettyDataBufferFactory(new UnpooledByteBufAllocator(false));
    private final HttpClient httpClient;

    public ReactorClientHttpConnector() {
        this.httpClient = HttpClient.builder().options(options -> options.compression(true)).build();
    }

    public ReactorClientHttpConnector(Consumer<? super HttpClientOptions.Builder> clientOptions) {
        this.httpClient = HttpClient.create(clientOptions);
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        if (!uri.isAbsolute()) {
            return Mono.error((Throwable)new IllegalArgumentException("URI is not absolute: " + uri));
        }
        return this.httpClient.request(this.adaptHttpMethod(method), uri.toString(), request -> (Mono)requestCallback.apply(this.adaptRequest(method, uri, (HttpClientRequest)request))).map(this::adaptResponse);
    }

    private com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpMethod adaptHttpMethod(HttpMethod method) {
        return com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpMethod.valueOf(method.name());
    }

    private ReactorClientHttpRequest adaptRequest(HttpMethod method, URI uri, HttpClientRequest request) {
        return new ReactorClientHttpRequest(method, uri, request);
    }

    private ClientHttpResponse adaptResponse(HttpClientResponse response) {
        return new ReactorClientHttpResponse(response);
    }
}

