/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client.support;

import com.baidu.cloud.thirdparty.springframework.http.HttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequestExecution;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequestInterceptor;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpResponse;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.Base64Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class BasicAuthorizationInterceptor
implements ClientHttpRequestInterceptor {
    private final String username;
    private final String password;

    public BasicAuthorizationInterceptor(@Nullable String username, @Nullable String password) {
        Assert.doesNotContain(username, ":", "Username must not contain a colon");
        this.username = username != null ? username : "";
        this.password = password != null ? password : "";
    }

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String token = Base64Utils.encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
        request.getHeaders().add("Authorization", "Basic " + token);
        return execution.execute(request, body);
    }
}

