/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.client.support;

import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAwareOrderComparator;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequestFactory;
import com.baidu.cloud.thirdparty.springframework.http.client.ClientHttpRequestInterceptor;
import com.baidu.cloud.thirdparty.springframework.http.client.InterceptingClientHttpRequestFactory;
import com.baidu.cloud.thirdparty.springframework.http.client.support.HttpAccessor;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class InterceptingHttpAccessor
extends HttpAccessor {
    private final List<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>();
    @Nullable
    private volatile ClientHttpRequestFactory interceptingRequestFactory;

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        if (this.interceptors != interceptors) {
            this.interceptors.clear();
            this.interceptors.addAll(interceptors);
            AnnotationAwareOrderComparator.sort(this.interceptors);
        }
    }

    public List<ClientHttpRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        super.setRequestFactory(requestFactory);
        this.interceptingRequestFactory = null;
    }

    @Override
    public ClientHttpRequestFactory getRequestFactory() {
        List<ClientHttpRequestInterceptor> interceptors = this.getInterceptors();
        if (!CollectionUtils.isEmpty(interceptors)) {
            ClientHttpRequestFactory factory = this.interceptingRequestFactory;
            if (factory == null) {
                this.interceptingRequestFactory = factory = new InterceptingClientHttpRequestFactory(super.getRequestFactory(), interceptors);
            }
            return factory;
        }
        return super.getRequestFactory();
    }
}

