/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.server.reactive;

import com.baidu.cloud.thirdparty.servlet.AsyncContext;
import com.baidu.cloud.thirdparty.servlet.ServletResponse;
import com.baidu.cloud.thirdparty.servlet.http.HttpServletResponse;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBuffer;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.DataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.HttpHandler;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServletServerHttpResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.server.HttpOutput;

public class JettyHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public JettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context) throws IOException {
        return new JettyServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize());
    }

    private static final class JettyServerHttpResponse
    extends ServletServerHttpResponse {
        public JettyServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize) throws IOException {
            super(response, context, factory, bufferSize);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ServletResponse response = (ServletResponse)this.getNativeResponse();
            ((HttpOutput)response.getOutputStream()).write(input);
            return len;
        }
    }
}

