/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.http.server.reactive;

import com.baidu.cloud.thirdparty.apache.commons.logging.Log;
import com.baidu.cloud.thirdparty.apache.commons.logging.LogFactory;
import com.baidu.cloud.thirdparty.netty.buffer.UnpooledByteBufAllocator;
import com.baidu.cloud.thirdparty.netty.handler.codec.http.HttpResponseStatus;
import com.baidu.cloud.thirdparty.springframework.core.io.buffer.NettyDataBufferFactory;
import com.baidu.cloud.thirdparty.springframework.http.HttpMethod;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.HttpHandler;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.HttpHeadResponseDecorator;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ReactorServerHttpRequest;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ReactorServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.http.server.reactive.ServerHttpResponse;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;

public class ReactorHttpHandlerAdapter
implements BiFunction<HttpServerRequest, HttpServerResponse, Mono<Void>> {
    private static final NettyDataBufferFactory BUFFER_FACTORY = new NettyDataBufferFactory(new UnpooledByteBufAllocator(false));
    private static final Log logger = LogFactory.getLog(ReactorHttpHandlerAdapter.class);
    private final HttpHandler httpHandler;

    public ReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, "HttpHandler must not be null");
        this.httpHandler = httpHandler;
    }

    @Override
    public Mono<Void> apply(HttpServerRequest request, HttpServerResponse response) {
        ServerHttpResponse adaptedResponse;
        ReactorServerHttpRequest adaptedRequest;
        try {
            adaptedRequest = new ReactorServerHttpRequest(request, BUFFER_FACTORY);
            adaptedResponse = new ReactorServerHttpResponse(response, BUFFER_FACTORY);
        }
        catch (URISyntaxException ex2) {
            if (logger.isWarnEnabled()) {
                logger.warn("Invalid URL for incoming request: " + ex2.getMessage());
            }
            response.status(HttpResponseStatus.BAD_REQUEST);
            return Mono.empty();
        }
        if (adaptedRequest.getMethod() == HttpMethod.HEAD) {
            adaptedResponse = new HttpHeadResponseDecorator(adaptedResponse);
        }
        return this.httpHandler.handle(adaptedRequest, adaptedResponse).doOnError(ex -> logger.warn("Handling completed with error: " + ex.getMessage())).doOnSuccess(aVoid -> logger.debug("Handling completed with success"));
    }
}

