/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.instrument.classloading.websphere;

import com.baidu.cloud.thirdparty.springframework.core.OverridingClassLoader;
import com.baidu.cloud.thirdparty.springframework.instrument.classloading.LoadTimeWeaver;
import com.baidu.cloud.thirdparty.springframework.instrument.classloading.websphere.WebSphereClassLoaderAdapter;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;

public class WebSphereLoadTimeWeaver
implements LoadTimeWeaver {
    private final WebSphereClassLoaderAdapter classLoader;

    public WebSphereLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public WebSphereLoadTimeWeaver(@Nullable ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, "ClassLoader must not be null");
        this.classLoader = new WebSphereClassLoaderAdapter(classLoader);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    @Override
    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getClassLoader();
    }

    @Override
    public ClassLoader getThrowawayClassLoader() {
        return new OverridingClassLoader(this.classLoader.getClassLoader(), this.classLoader.getThrowawayClassLoader());
    }
}

