/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.jmx.export.naming;

import com.baidu.cloud.thirdparty.springframework.aop.support.AopUtils;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.JmxAttributeSource;
import com.baidu.cloud.thirdparty.springframework.jmx.export.metadata.ManagedResource;
import com.baidu.cloud.thirdparty.springframework.jmx.export.naming.ObjectNamingStrategy;
import com.baidu.cloud.thirdparty.springframework.jmx.support.ObjectNameManager;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.ClassUtils;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MetadataNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    @Nullable
    private JmxAttributeSource attributeSource;
    @Nullable
    private String defaultDomain;

    public MetadataNamingStrategy() {
    }

    public MetadataNamingStrategy(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, "JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        Assert.notNull((Object)attributeSource, "JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("Property 'attributeSource' is required");
        }
    }

    @Override
    public ObjectName getObjectName(Object managedBean, @Nullable String beanKey) throws MalformedObjectNameException {
        Assert.state(this.attributeSource != null, "No JmxAttributeSource set");
        Class<?> managedClass = AopUtils.getTargetClass(managedBean);
        ManagedResource mr = this.attributeSource.getManagedResource(managedClass);
        if (mr != null && StringUtils.hasText(mr.getObjectName())) {
            return ObjectNameManager.getInstance(mr.getObjectName());
        }
        Assert.state(beanKey != null, "No ManagedResource attribute and no bean key specified");
        try {
            return ObjectNameManager.getInstance(beanKey);
        }
        catch (MalformedObjectNameException ex) {
            String domain = this.defaultDomain;
            if (domain == null) {
                domain = ClassUtils.getPackageName(managedClass);
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("type", ClassUtils.getShortName(managedClass));
            properties.put("name", beanKey);
            return ObjectNameManager.getInstance(domain, properties);
        }
    }
}

