/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.jndi;

import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.jndi.JndiLocatorSupport;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.util.StringUtils;
import javax.naming.NamingException;

public abstract class JndiObjectLocator
extends JndiLocatorSupport
implements InitializingBean {
    @Nullable
    private String jndiName;
    @Nullable
    private Class<?> expectedType;

    public void setJndiName(@Nullable String jndiName) {
        this.jndiName = jndiName;
    }

    @Nullable
    public String getJndiName() {
        return this.jndiName;
    }

    public void setExpectedType(@Nullable Class<?> expectedType) {
        this.expectedType = expectedType;
    }

    @Nullable
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        if (!StringUtils.hasLength(this.getJndiName())) {
            throw new IllegalArgumentException("Property 'jndiName' is required");
        }
    }

    protected Object lookup() throws NamingException {
        String jndiName = this.getJndiName();
        Assert.state(jndiName != null, "No JNDI name specified");
        return this.lookup(jndiName, this.getExpectedType());
    }
}

