/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.jndi;

import com.baidu.cloud.thirdparty.springframework.aop.TargetSource;
import com.baidu.cloud.thirdparty.springframework.jndi.JndiLookupFailureException;
import com.baidu.cloud.thirdparty.springframework.jndi.JndiObjectLocator;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import javax.naming.NamingException;

public class JndiObjectTargetSource
extends JndiObjectLocator
implements TargetSource {
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    @Nullable
    private Object cachedObject;
    @Nullable
    private Class<?> targetClass;

    public void setLookupOnStartup(boolean lookupOnStartup) {
        this.lookupOnStartup = lookupOnStartup;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.lookupOnStartup) {
            Object object = this.lookup();
            if (this.cache) {
                this.cachedObject = object;
            } else {
                this.targetClass = object.getClass();
            }
        }
    }

    @Override
    @Nullable
    public Class<?> getTargetClass() {
        if (this.cachedObject != null) {
            return this.cachedObject.getClass();
        }
        if (this.targetClass != null) {
            return this.targetClass;
        }
        return this.getExpectedType();
    }

    @Override
    public boolean isStatic() {
        return this.cachedObject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getTarget() {
        try {
            if (this.lookupOnStartup || !this.cache) {
                return this.cachedObject != null ? this.cachedObject : this.lookup();
            }
            JndiObjectTargetSource jndiObjectTargetSource = this;
            synchronized (jndiObjectTargetSource) {
                if (this.cachedObject == null) {
                    this.cachedObject = this.lookup();
                }
                return this.cachedObject;
            }
        }
        catch (NamingException ex) {
            throw new JndiLookupFailureException("JndiObjectTargetSource failed to obtain new target object", ex);
        }
    }

    @Override
    public void releaseTarget(Object target) {
    }
}

