/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.objenesis.strategy;

import com.baidu.cloud.thirdparty.springframework.objenesis.ObjenesisException;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.ObjectInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.android.AndroidSerializationInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.perc.PercSerializationInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.instantiator.sun.SunReflectionFactorySerializationInstantiator;
import com.baidu.cloud.thirdparty.springframework.objenesis.strategy.BaseInstantiatorStrategy;
import com.baidu.cloud.thirdparty.springframework.objenesis.strategy.PlatformDescription;
import java.io.NotSerializableException;
import java.io.Serializable;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine() && PlatformDescription.SPECIFICATION_VERSION.equals("1.7")) {
                return new ObjectInputStreamInstantiator<T>(type);
            }
            return new SunReflectionFactorySerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new SunReflectionFactorySerializationInstantiator<T>(type);
    }
}

