/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.scheduling.annotation;

import com.baidu.cloud.thirdparty.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import com.baidu.cloud.thirdparty.springframework.beans.factory.annotation.Autowired;
import com.baidu.cloud.thirdparty.springframework.context.annotation.Configuration;
import com.baidu.cloud.thirdparty.springframework.context.annotation.ImportAware;
import com.baidu.cloud.thirdparty.springframework.core.annotation.AnnotationAttributes;
import com.baidu.cloud.thirdparty.springframework.core.type.AnnotationMetadata;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.scheduling.annotation.AsyncConfigurer;
import com.baidu.cloud.thirdparty.springframework.scheduling.annotation.EnableAsync;
import com.baidu.cloud.thirdparty.springframework.util.CollectionUtils;
import java.util.Collection;
import java.util.concurrent.Executor;

@Configuration
public abstract class AbstractAsyncConfiguration
implements ImportAware {
    @Nullable
    protected AnnotationAttributes enableAsync;
    @Nullable
    protected Executor executor;
    @Nullable
    protected AsyncUncaughtExceptionHandler exceptionHandler;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableAsync = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableAsync.class.getName(), false));
        if (this.enableAsync == null) {
            throw new IllegalArgumentException("@EnableAsync is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<AsyncConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one AsyncConfigurer may exist");
        }
        AsyncConfigurer configurer = configurers.iterator().next();
        this.executor = configurer.getAsyncExecutor();
        this.exceptionHandler = configurer.getAsyncUncaughtExceptionHandler();
    }
}

