/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.util.concurrent;

import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.concurrent.FailureCallback;
import com.baidu.cloud.thirdparty.springframework.util.concurrent.FutureAdapter;
import com.baidu.cloud.thirdparty.springframework.util.concurrent.ListenableFuture;
import com.baidu.cloud.thirdparty.springframework.util.concurrent.ListenableFutureCallback;
import com.baidu.cloud.thirdparty.springframework.util.concurrent.SuccessCallback;
import java.util.concurrent.ExecutionException;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.addCallback(callback, callback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(@Nullable S result) {
                Object adapted = null;
                if (result != null) {
                    try {
                        adapted = ListenableFutureAdapter.this.adaptInternal(result);
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        this.onFailure(cause != null ? cause : ex);
                        return;
                    }
                    catch (Throwable ex) {
                        this.onFailure(ex);
                        return;
                    }
                }
                successCallback.onSuccess(adapted);
            }

            @Override
            public void onFailure(Throwable ex) {
                failureCallback.onFailure(ex);
            }
        });
    }
}

