/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.cloud.thirdparty.springframework.validation.beanvalidation;

import com.baidu.cloud.thirdparty.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import com.baidu.cloud.thirdparty.springframework.aop.support.DefaultPointcutAdvisor;
import com.baidu.cloud.thirdparty.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import com.baidu.cloud.thirdparty.springframework.beans.factory.InitializingBean;
import com.baidu.cloud.thirdparty.springframework.lang.Nullable;
import com.baidu.cloud.thirdparty.springframework.util.Assert;
import com.baidu.cloud.thirdparty.springframework.validation.annotation.Validated;
import com.baidu.cloud.thirdparty.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import com.baidu.cloud.thirdparty.springframework.validation.beanvalidation.MethodValidationInterceptor;
import com.baidu.cloud.thirdparty.springframework.validation.beanvalidation.SpringValidatorAdapter;
import java.lang.annotation.Annotation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aopalliance.aop.Advice;

public class MethodValidationPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor
implements InitializingBean {
    private Class<? extends Annotation> validatedAnnotationType = Validated.class;
    @Nullable
    private Validator validator;

    public void setValidatedAnnotationType(Class<? extends Annotation> validatedAnnotationType) {
        Assert.notNull(validatedAnnotationType, "'validatedAnnotationType' must not be null");
        this.validatedAnnotationType = validatedAnnotationType;
    }

    public void setValidator(Validator validator) {
        this.validator = validator instanceof LocalValidatorFactoryBean ? ((LocalValidatorFactoryBean)validator).getValidator() : (validator instanceof SpringValidatorAdapter ? (Validator)validator.unwrap(Validator.class) : validator);
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    @Override
    public void afterPropertiesSet() {
        AnnotationMatchingPointcut pointcut = new AnnotationMatchingPointcut(this.validatedAnnotationType, true);
        this.advisor = new DefaultPointcutAdvisor(pointcut, this.createMethodValidationAdvice(this.validator));
    }

    protected Advice createMethodValidationAdvice(@Nullable Validator validator) {
        return validator != null ? new MethodValidationInterceptor(validator) : new MethodValidationInterceptor();
    }
}

